<?php
$pageTitle = "Paid / Unpaid / Pending Report";
include_once "../layout/header.php";
include_once "../layout/sidebar.php";
include_once "../config/db.php";

$month   = date('n');
$year    = date('Y');
$adminId = $_SESSION['admin_id'];
$role    = $_SESSION['admin_role'] ?? 'ADMIN';

$whereAdmin = ($role === 'SUPER') ? "" : " AND c.admin_id = $adminId";

/* ================= SUMMARY COUNTS ================= */
$paid = $conn->query("
    SELECT COUNT(DISTINCT b.customer_id) total
    FROM bills b
    JOIN customers c ON b.customer_id=c.id
    WHERE b.bill_month=$month AND b.bill_year=$year
      AND b.status='PAID' $whereAdmin
")->fetch_assoc()['total'];

$unpaid = $conn->query("
    SELECT COUNT(DISTINCT b.customer_id) total
    FROM bills b
    JOIN customers c ON b.customer_id=c.id
    WHERE b.bill_month=$month AND b.bill_year=$year
      AND b.status='UNPAID' $whereAdmin
")->fetch_assoc()['total'];

$partial = $conn->query("
    SELECT COUNT(DISTINCT b.customer_id) total
    FROM bills b
    JOIN customers c ON b.customer_id=c.id
    WHERE b.bill_month=$month AND b.bill_year=$year
      AND b.status='PARTIAL' $whereAdmin
")->fetch_assoc()['total'];

$notGenerated = $conn->query("
    SELECT COUNT(*) total
    FROM customers c
    WHERE c.status='Active' $whereAdmin
      AND NOT EXISTS (
          SELECT 1 FROM bills b
          WHERE b.customer_id=c.id
            AND b.bill_month=$month
            AND b.bill_year=$year
      )
")->fetch_assoc()['total'];

/* ================= CUSTOMER LIST ================= */
$customers = $conn->query("
    SELECT
        c.id,
        c.Name,
        c.`VC Number`,
        b.status,
        b.amount,
        b.paid_amount,
        (b.amount - b.paid_amount) AS pending
    FROM customers c
    LEFT JOIN bills b 
        ON b.customer_id=c.id
       AND b.bill_month=$month
       AND b.bill_year=$year
    WHERE c.status='Active' $whereAdmin
    ORDER BY
        CASE
            WHEN b.status='UNPAID' THEN 1
            WHEN b.status='PARTIAL' THEN 2
            WHEN b.status='PAID' THEN 3
            ELSE 4
        END
");
?>

<style>
/* ---------- GRID & CARDS ---------- */
.card-grid {
    display:grid;
    grid-template-columns:repeat(auto-fit,minmax(220px,1fr));
    gap:16px;
    margin:20px 0;
}
.card {
    background:#fff;
    padding:20px;
    border-radius:14px;
    box-shadow:0 10px 26px rgba(0,0,0,0.06);
}
.card h3 { margin:0 0 6px; }

/* ---------- COLORS ---------- */
.green { border-left:6px solid #22C55E; }
.red { border-left:6px solid #EF4444; }
.orange { border-left:6px solid #F59E0B; }
.blue { border-left:6px solid #3B82F6; }

/* ---------- CHART SECTION ---------- */
.chart-wrapper {
    display:flex;
    justify-content:center;
    align-items:center;
    padding:20px 0;
}
.chart-box {
    width:320px;
    max-width:100%;
}

/* ---------- TABLE ---------- */
.table {
    width:100%;
    border-collapse:collapse;
    margin-top:10px;
}
.table th {
    background:#F8FAFC;
    text-align:left;
    padding:12px;
    font-size:13px;
}
.table td {
    padding:12px;
    border-bottom:1px solid #E5E7EB;
}
.table tr { cursor:pointer; transition:0.2s; }
.table tr:hover { background:#F1F5F9; }

/* ---------- STATUS ROWS ---------- */
.row-paid { background:#ECFDF5; }
.row-unpaid { background:#FEF2F2; }
.row-partial { background:#FFF7ED; }
.row-nogen { background:#EFF6FF; }

/* ---------- BADGES ---------- */
.badge {
    padding:4px 10px;
    border-radius:999px;
    font-size:12px;
    font-weight:600;
    color:#fff;
}
.badge-paid { background:#22C55E; }
.badge-unpaid { background:#EF4444; }
.badge-partial { background:#F59E0B; }
.badge-nogen { background:#3B82F6; }

/* ---------- RESPONSIVE ---------- */
@media(max-width:768px){
    .chart-box { width:260px; }
}
</style>

<main class="main-content">

<div class="page-header">
    <h2>Paid / Unpaid / Pending Report</h2>
    <p>Customer payment status for current month</p>
</div>

<!-- SUMMARY -->
<div class="card-grid">
    <div class="card green"><h3>🟢 Paid</h3><p><?= $paid ?></p></div>
    <div class="card red"><h3>🔴 Unpaid</h3><p><?= $unpaid ?></p></div>
    <div class="card orange"><h3>🟠 Partial</h3><p><?= $partial ?></p></div>
    <div class="card blue"><h3>🔵 Not Generated</h3><p><?= $notGenerated ?></p></div>
</div>

<!-- CHART -->
<div class="card">
    <h3>Status Distribution</h3>
    <div class="chart-wrapper">
        <div class="chart-box">
            <canvas id="statusChart"></canvas>
        </div>
    </div>
</div>

<!-- CUSTOMER TABLE -->
<div class="card">
    <h3>Customer Payment Status</h3>

    <table class="table">
        <tr>
            <th>Customer</th>
            <th>VC</th>
            <th>Status</th>
            <th>Pending</th>
        </tr>

        <?php while($r=$customers->fetch_assoc()):
            $status='NOT GENERATED'; $row='row-nogen'; $badge='badge-nogen';
            $pending='—'; $link="../customers/customer_details.php?id=".$r['id'];

            if ($r['status']=='PAID') {
                $status='PAID'; $row='row-paid'; $badge='badge-paid';
                $pending='₹0'; $link="../bills/view_bill.php?customer_id=".$r['id'];
            } elseif ($r['status']=='UNPAID') {
                $status='UNPAID'; $row='row-unpaid'; $badge='badge-unpaid';
                $pending='₹'.number_format($r['pending'],2);
                $link="../bills/collect_payment.php?customer_id=".$r['id'];
            } elseif ($r['status']=='PARTIAL') {
                $status='PARTIAL'; $row='row-partial'; $badge='badge-partial';
                $pending='₹'.number_format($r['pending'],2);
                $link="../bills/collect_payment.php?customer_id=".$r['id'];
            }
        ?>
        <tr class="<?= $row ?>" onclick="window.location.href='<?= $link ?>'">
            <td><?= htmlspecialchars($r['Name']) ?></td>
            <td><?= htmlspecialchars($r['VC Number']) ?></td>
            <td><span class="badge <?= $badge ?>"><?= $status ?></span></td>
            <td><?= $pending ?></td>
        </tr>
        <?php endwhile; ?>
    </table>
</div>

</main>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
new Chart(document.getElementById('statusChart'),{
    type:'doughnut',
    data:{
        labels:['Paid','Unpaid','Partial','Not Generated'],
        datasets:[{
            data:[<?= $paid ?>,<?= $unpaid ?>,<?= $partial ?>,<?= $notGenerated ?>],
            backgroundColor:['#22C55E','#EF4444','#F59E0B','#3B82F6'],
            borderWidth:0
        }]
    },
    options:{
        cutout:'70%',
        plugins:{ legend:{ position:'bottom' } }
    }
});
</script>

<?php include_once "../layout/footer.php"; ?>
