<?php
include_once __DIR__ . '/auth_check.php';
include_once __DIR__ . '/config/db.php';


/* ================= PAGE TITLE ================= */
$pageTitle = "Bills";

/* ================= HEADER ================= */
include_once __DIR__ . "/layout/header.php";

$adminId = $_SESSION['admin_id'];
$role    = $_SESSION['admin_role'];

$billMonth = (int)date('n');
$billYear  = (int)date('Y');

/* ================= GENERATED BILLS ================= */
if ($role === 'SUPER') {

    $generated = $conn->query("
        SELECT 
            b.bill_month,
            b.bill_year,
            b.amount,
            b.paid_amount,
            b.status,
            c.`Account No` AS account_no,
            c.`Name` AS customer_name
        FROM bills b
        JOIN customers c ON b.customer_id = c.id
        WHERE b.bill_month = $billMonth
          AND b.bill_year  = $billYear
        ORDER BY c.`Name`
    ");

    /* ================= SKIPPED CUSTOMERS ================= */
    $skipped = $conn->query("
        SELECT 
            c.`Account No` AS account_no,
            c.`Name` AS customer_name
        FROM customers c
        LEFT JOIN packages p ON c.`Package` = p.id
        WHERE c.`Status` = 'Active'
          AND (p.price IS NULL OR p.price <= 0)
    ");

} else {

    $stmt = $conn->prepare("
        SELECT 
            b.bill_month,
            b.bill_year,
            b.amount,
            b.paid_amount,
            b.status,
            c.`Account No` AS account_no,
            c.`Name` AS customer_name
        FROM bills b
        JOIN customers c ON b.customer_id = c.id
        WHERE b.bill_month = ?
          AND b.bill_year  = ?
          AND c.admin_id  = ?
        ORDER BY c.`Name`
    ");
    $stmt->bind_param("iii", $billMonth, $billYear, $adminId);
    $stmt->execute();
    $generated = $stmt->get_result();

    /* ================= SKIPPED CUSTOMERS ================= */
    $stmt2 = $conn->prepare("
        SELECT 
            c.`Account No` AS account_no,
            c.`Name` AS customer_name
        FROM customers c
        LEFT JOIN packages p ON c.`Package` = p.id
        WHERE c.`Status` = 'Active'
          AND c.admin_id = ?
          AND (p.price IS NULL OR p.price <= 0)
    ");
    $stmt2->bind_param("i", $adminId);
    $stmt2->execute();
    $skipped = $stmt2->get_result();
}

$notGeneratedCount = $skipped->num_rows;
?>
<!DOCTYPE html>
<html>
<head>
    <title>Bills</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<main class="main-content">
<div class="container mt-4">

<h3>Bills – <?= date('F Y') ?></h3>

<!-- 🔴 NOT GENERATED ALERT BUTTON -->
<?php if ($notGeneratedCount > 0): ?>
    <div class="alert alert-danger d-flex justify-content-between align-items-center">
        <div>
            ⚠ <strong><?= $notGeneratedCount ?></strong>
            customer bills are <strong>NOT GENERATED</strong>
        </div>
        <a href="#not-generated" class="btn btn-sm btn-outline-dark">
            View / Fix Now
        </a>
    </div>
<?php endif; ?>

<table class="table table-bordered table-striped">
<thead class="table-dark">
<tr>
    <th>#</th>
    <th>Account No</th>
    <th>Name</th>
    <th>Month</th>
    <th>Bill</th>
    <th>Paid</th>
    <th>Balance</th>
    <th>Status</th>
</tr>
</thead>
<tbody>

<?php
$i = 1;
while ($r = $generated->fetch_assoc()):
    $balance = $r['amount'] - $r['paid_amount'];
?>
<tr>
    <td><?= $i++ ?></td>
    <td><?= htmlspecialchars($r['account_no']) ?></td>
    <td><?= htmlspecialchars($r['customer_name']) ?></td>
    <td><?= date('F Y', mktime(0,0,0,$r['bill_month'],1,$r['bill_year'])) ?></td>
    <td>₹<?= number_format($r['amount'],2) ?></td>
    <td class="text-success fw-bold">₹<?= number_format($r['paid_amount'],2) ?></td>
    <td>
        <?php if ($balance > 0): ?>
            <span class="text-danger fw-bold">− ₹<?= number_format($balance,2) ?></span>
        <?php elseif ($balance < 0): ?>
            <span class="text-success fw-bold">+ ₹<?= number_format(abs($balance),2) ?></span>
        <?php else: ?>
            ₹0.00
        <?php endif; ?>
    </td>
    <td>
        <span class="badge 
            <?= $r['status']=='PAID'
                ? 'bg-success'
                : ($r['status']=='PARTIAL'
                    ? 'bg-warning'
                    : 'bg-secondary') ?>">
            <?= $r['status'] ?>
        </span>
    </td>
</tr>
<?php endwhile; ?>
</tbody>
</table>

<!-- ⚠ SKIPPED CUSTOMERS SECTION -->
<?php if ($notGeneratedCount > 0): ?>
    <div id="not-generated" class="alert alert-warning mt-4">
        <strong>⚠ Bills NOT Generated (Package price not set)</strong>
        <ul class="mb-0 mt-2">
            <?php while ($s = $skipped->fetch_assoc()): ?>
                <li>
                    <?= htmlspecialchars($s['customer_name']) ?>
                    (<?= htmlspecialchars($s['account_no']) ?>)
                    — <em>Set package price first</em>
                </li>
            <?php endwhile; ?>
        </ul>
    </div>
<?php endif; ?>

<a href="dashboard.php" class="btn btn-secondary mt-3">Back</a>

</div>

</main>


<?php include_once __DIR__ . "/layout/footer.php"; ?>
</body>
</html>
