<?php
include_once __DIR__ . '/auth_check.php';
include_once __DIR__ . '/config/db.php';

/* ================= PAGE TITLE ================= */
$pageTitle = "Generate Bills";
include_once __DIR__ . "/layout/header.php";

$message = '';
$errorMsg = '';

$adminId = $_SESSION['admin_id'];
$role    = $_SESSION['admin_role'];

/* ================= CURRENT BILLING MONTH/YEAR ================= */
$billMonth  = (int)date('n');
$billYear   = (int)date('Y');
$monthLabel = date('F Y');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    /* ================= FETCH ACTIVE CUSTOMERS ================= */
    if ($role === 'SUPER') {
        $sql = "
            SELECT c.id, IFNULL(p.price,0) AS package_price
            FROM customers c
            LEFT JOIN packages p ON c.`Package` = p.id
            WHERE c.`Status` = 'Active'
        ";
        $stmt = $conn->prepare($sql);
    } else {
        $sql = "
            SELECT c.id, IFNULL(p.price,0) AS package_price
            FROM customers c
            LEFT JOIN packages p ON c.`Package` = p.id
            WHERE c.`Status` = 'Active'
              AND c.admin_id = ?
        ";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("i", $adminId);
    }

    $stmt->execute();
    $res = $stmt->get_result();

    $inserted = 0;
    $skipped  = 0;

    while ($row = $res->fetch_assoc()) {

        $customerId   = (int)$row['id'];
        $packagePrice = (float)$row['package_price'];

        if ($packagePrice <= 0) {
            $skipped++;
            continue;
        }

        /* ================= CHECK CURRENT MONTH BILL ================= */
        $check = $conn->prepare("
            SELECT id
            FROM bills
            WHERE customer_id = ?
              AND bill_month = ?
              AND bill_year  = ?
        ");
        $check->bind_param("iii", $customerId, $billMonth, $billYear);
        $check->execute();
        $exists = $check->get_result()->fetch_assoc();
        $check->close();

        if ($exists) {
            /* ❌ Bill already generated for this month */
            $skipped++;
            continue;
        }

        /* ================= INSERT NEW MONTH BILL ================= */
        $ins = $conn->prepare("
            INSERT INTO bills
                (customer_id, bill_month, bill_year, bill_date, amount, paid_amount, status)
            VALUES
                (?, ?, ?, CURDATE(), ?, 0, 'UNPAID')
        ");
        $ins->bind_param(
            "iiid",
            $customerId,
            $billMonth,
            $billYear,
            $packagePrice
        );

        if ($ins->execute()) {
            $inserted++;
        } else {
            $skipped++;
        }
        $ins->close();
    }

    $stmt->close();

    $message = "✅ Bills generated for $monthLabel | New: $inserted | Skipped: $skipped";
}
?>

<main class="main-content">
<div class="container mt-4">

    <h3 class="mb-3">Generate Bills</h3>

    <p class="text-muted">
        Billing Month:
        <strong><?= htmlspecialchars($monthLabel) ?></strong>
        <?php if ($role !== 'SUPER'): ?>
            <span class="badge bg-info ms-2">Only Your Customers</span>
        <?php endif; ?>
    </p>

    <?php if ($message): ?>
        <div class="alert alert-success">
            <?= htmlspecialchars($message) ?>
        </div>
    <?php endif; ?>

    <form method="post"
          onsubmit="return confirm('Generate bills for <?= $monthLabel ?>?');">

        <button class="btn btn-primary">
            Generate Bills
        </button>

        <a href="dashboard.php" class="btn btn-secondary ms-2">
            Back
        </a>
    </form>

</div>
</main>

<?php include_once __DIR__ . "/layout/footer.php"; ?>
