<?php
include_once __DIR__ . '/auth_check.php';
include_once __DIR__ . '/config/db.php';

/* ================= PAGE TITLE ================= */
$pageTitle = "AddCustomer";

/* ================= HEADER ================= */
include_once __DIR__ . "/layout/header.php";

$adminId = $_SESSION['admin_id'];
$role    = $_SESSION['admin_role'];

$error = '';

/* LOAD PACKAGES */
if ($role === 'SUPER') {
    $packages = $conn->query(
        "SELECT id, name FROM packages WHERE status='Active'"
    );
} else {
    $stmt = $conn->prepare(
        "SELECT id, name FROM packages WHERE status='Active' AND admin_id=?"
    );
    $stmt->bind_param("i", $adminId);
    $stmt->execute();
    $packages = $stmt->get_result();
}

/* SAVE CUSTOMER */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $account_no = strtoupper(trim($_POST['account_no']));
    $name       = trim($_POST['name']);
    $address    = trim($_POST['address']);
    $mobile     = trim($_POST['mobile']);
    $vc_number  = trim($_POST['vc_number']);
    $serial_no  = trim($_POST['serial_number']);
    $package_id = intval($_POST['package_id']);
    $status     = $_POST['status'];

    if ($account_no === '' || $name === '') {
        $error = 'Account No and Name are required';
    } else {

        /* 🔢 GET NEXT CUSTOMER_NO (PER ADMIN) */
        $stmt = $conn->prepare("
            SELECT IFNULL(MAX(customer_no), 0) + 1
            FROM customers
            WHERE admin_id = ?
        ");
        $stmt->bind_param("i", $adminId);
        $stmt->execute();
        $stmt->bind_result($customer_no);
        $stmt->fetch();
        $stmt->close();

        /* INSERT CUSTOMER */
        $stmt = $conn->prepare("
            INSERT INTO customers
            (`Account No`, `Name`, `Address`, `Mobile No`,
             `VC Number`, `Serial Number`, `Package`, `Status`,
             admin_id, customer_no)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
        ");

        /* ✅ CORRECT bind_param TYPES */
        $stmt->bind_param(
            "ssssssissi",
            $account_no,
            $name,
            $address,
            $mobile,
            $vc_number,
            $serial_no,
            $package_id,
            $status,
            $adminId,
            $customer_no
        );

        if ($stmt->execute()) {
            header("Location: customers.php");
            exit;
        } else {
            $error = ($conn->errno == 1062)
                ? "Account number already exists"
                : "Database error";
        }
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Add Customer</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <main class="main-content">

<div class="container mt-4">
    <h3>Add Customer</h3>

    <?php if ($error): ?>
        <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <form method="post">

        <div class="mb-2">
            <label>Account No</label>
            <input class="form-control" name="account_no" required>
        </div>

        <div class="mb-2">
            <label>Name</label>
            <input class="form-control" name="name" required>
        </div>

        <div class="mb-2">
            <label>Address</label>
            <textarea class="form-control" name="address"></textarea>
        </div>

        <div class="mb-2">
            <label>Mobile</label>
            <input class="form-control" name="mobile">
        </div>

        <div class="mb-2">
            <label>VC Number</label>
            <input class="form-control" name="vc_number">
        </div>

        <div class="mb-2">
            <label>Serial Number</label>
            <input class="form-control" name="serial_number">
        </div>

        <div class="mb-2">
            <label>Package</label>
            <select name="package_id" class="form-control" required>
                <?php while ($p = $packages->fetch_assoc()): ?>
                    <option value="<?= $p['id'] ?>">
                        <?= htmlspecialchars($p['name']) ?>
                    </option>
                <?php endwhile; ?>
            </select>
        </div>

        <div class="mb-3">
            <label>Status</label>
            <select name="status" class="form-control">
                <option value="Active">Active</option>
                <option value="Inactive">Inactive</option>
            </select>
        </div>

        <button class="btn btn-success">Save Customer</button>
        <a href="customers.php" class="btn btn-secondary">Cancel</a>

    </form>
</div>

</main>


<?php include_once __DIR__ . "/layout/footer.php"; ?>

</body>
</html>
