<?php
include_once __DIR__ . '/auth_check.php';
include_once __DIR__ . '/config/db.php';

$adminId = $_SESSION['admin_id'];
$role    = $_SESSION['admin_role'];

$customer_id = intval($_GET['id'] ?? 0);

if ($customer_id <= 0) {
    header("Location: customers.php");
    exit;
}

/*
|--------------------------------------------------------------------------
| FETCH CUSTOMER (ROLE BASED)
|--------------------------------------------------------------------------
| SUPER  -> can view any customer bills
| ADMIN  -> only own customers
*/

if ($role === 'SUPER') {

    $stmt = $conn->prepare("
        SELECT 
            c.`Account No` AS account_no,
            c.`Name` AS name
        FROM customers c
        WHERE c.id = ?
        LIMIT 1
    ");
    $stmt->bind_param("i", $customer_id);

} else {

    $stmt = $conn->prepare("
        SELECT 
            c.`Account No` AS account_no,
            c.`Name` AS name
        FROM customers c
        WHERE c.id = ? AND c.admin_id = ?
        LIMIT 1
    ");
    $stmt->bind_param("ii", $customer_id, $adminId);
}

$stmt->execute();
$customer = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$customer) {
    // Customer does not exist OR access denied
    header("Location: customers.php");
    exit;
}

/*
|--------------------------------------------------------------------------
| FETCH BILLS (SAFE)
|--------------------------------------------------------------------------
*/

$bills = $conn->prepare("
    SELECT 
        id,
        bill_month,
        amount,
        status
    FROM bills
    WHERE customer_id = ?
    ORDER BY bill_month DESC
");
$bills->bind_param("i", $customer_id);
$bills->execute();
$result = $bills->get_result();
?>
<!DOCTYPE html>
<html>
<head>
    <title>Customer Bills</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>

<div class="container mt-4">

    <div class="d-flex justify-content-between mb-3">
        <h3>
            Bills – <?= htmlspecialchars($customer['name']) ?>
            (<?= htmlspecialchars($customer['account_no']) ?>)
        </h3>
        <a href="customers.php" class="btn btn-secondary">Back</a>
    </div>

    <table class="table table-bordered table-striped">
        <thead class="table-dark">
        <tr>
            <th>#</th>
            <th>Month</th>
            <th>Amount (₹)</th>
            <th>Status</th>
        </tr>
        </thead>
        <tbody>

        <?php if ($result->num_rows > 0): ?>
            <?php $i = 1; while ($row = $result->fetch_assoc()): ?>
                <tr>
                    <td><?= $i++ ?></td>
                    <td><?= date('F Y', strtotime($row['bill_month'])) ?></td>
                    <td>₹<?= number_format((float)$row['amount'], 2) ?></td>
                    <td>
                        <span class="badge <?= $row['status'] === 'PAID' ? 'bg-success' : 'bg-warning' ?>">
                            <?= htmlspecialchars($row['status']) ?>
                        </span>
                    </td>
                </tr>
            <?php endwhile; ?>
        <?php else: ?>
            <tr>
                <td colspan="4" class="text-center">No bills found</td>
            </tr>
        <?php endif; ?>

        </tbody>
    </table>

</div>

</body>
</html>
