<?php
include_once __DIR__ . '/auth_check.php';
include_once __DIR__ . '/config/db.php';
include_once __DIR__ . '/config/admin_log.php';

$adminId = $_SESSION['admin_id'];
$role    = $_SESSION['admin_role'];

$id = intval($_GET['id'] ?? 0);

if ($id <= 0) {
    header("Location: customers.php");
    exit;
}

/*
|--------------------------------------------------------------------------
| DELETE CUSTOMER (ROLE BASED)
|--------------------------------------------------------------------------
| SUPER  -> delete any customer
| ADMIN  -> delete only own customers
*/

if ($role === 'SUPER') {

    $stmt = $conn->prepare(
        "DELETE FROM customers WHERE id = ? LIMIT 1"
    );
    $stmt->bind_param("i", $id);

} else {

    $stmt = $conn->prepare(
        "DELETE FROM customers WHERE id = ? AND admin_id = ? LIMIT 1"
    );
    $stmt->bind_param("ii", $id, $adminId);
}

$stmt->execute();
$affectedRows = $stmt->affected_rows;
$stmt->close();

/*
|--------------------------------------------------------------------------
| ADMIN LOG
|--------------------------------------------------------------------------
| Log only if delete actually happened
*/

if ($affectedRows > 0) {

    adminLog(
        'DELETE',
        'CUSTOMER',
        $id,
        ($role === 'SUPER')
            ? 'Customer deleted by SUPER admin'
            : 'Customer deleted by ADMIN (own customer)'
    );
}

// Redirect always
header("Location: customers.php");
exit;
