<?php
include_once __DIR__ . '/auth_check.php';
include_once __DIR__ . '/config/db.php';

error_reporting(E_ALL);
ini_set('display_errors', 1);

$adminId = $_SESSION['admin_id'];
$role    = $_SESSION['admin_role'];

$id = intval($_GET['id'] ?? 0);
$error = '';

if ($id <= 0) {
    header("Location: customers.php");
    exit;
}

/*
|--------------------------------------------------------------------------
| FETCH CUSTOMER (ROLE BASED)
|--------------------------------------------------------------------------
| SUPER  -> any customer
| ADMIN  -> only own customers
*/

if ($role === 'SUPER') {
    $stmt = $conn->prepare("SELECT * FROM customers WHERE id = ?");
    $stmt->bind_param("i", $id);
} else {
    $stmt = $conn->prepare(
        "SELECT * FROM customers WHERE id = ? AND admin_id = ?"
    );
    $stmt->bind_param("ii", $id, $adminId);
}

$stmt->execute();
$customer = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$customer) {
    // Either customer does not exist OR access denied
    header("Location: customers.php");
    exit;
}

/* Load active packages */
$packages = $conn->query(
    "SELECT id, name FROM packages WHERE status='Active'"
);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $name        = trim($_POST['name'] ?? '');
    $address     = trim($_POST['address'] ?? '');
    $mobile      = trim($_POST['mobile'] ?? '');
    $vc_number   = trim($_POST['vc_number'] ?? '');
    $serial_no   = trim($_POST['serial_number'] ?? '');
    $package_id  = intval($_POST['package_id'] ?? 0);
    $status      = $_POST['status'] ?? 'Inactive';

    if ($name === '') {
        $error = "Name is required";
    } else {

        /*
        |--------------------------------------------------------------------------
        | UPDATE CUSTOMER (ROLE BASED)
        |--------------------------------------------------------------------------
        */

        if ($role === 'SUPER') {

            $sql = "
                UPDATE customers SET
                    `Name` = ?,
                    `Address` = ?,
                    `Mobile No` = ?,
                    `VC Number` = ?,
                    `Serial Number` = ?,
                    `Package` = ?,
                    `Status` = ?
                WHERE id = ?
                LIMIT 1
            ";

            $stmt = $conn->prepare($sql);
            $stmt->bind_param(
                "sssssisi",
                $name,
                $address,
                $mobile,
                $vc_number,
                $serial_no,
                $package_id,
                $status,
                $id
            );

        } else {

            $sql = "
                UPDATE customers SET
                    `Name` = ?,
                    `Address` = ?,
                    `Mobile No` = ?,
                    `VC Number` = ?,
                    `Serial Number` = ?,
                    `Package` = ?,
                    `Status` = ?
                WHERE id = ? AND admin_id = ?
                LIMIT 1
            ";

            $stmt = $conn->prepare($sql);
            $stmt->bind_param(
                "sssssisii",
                $name,
                $address,
                $mobile,
                $vc_number,
                $serial_no,
                $package_id,
                $status,
                $id,
                $adminId
            );
        }

        if ($stmt->execute()) {
            header("Location: customers.php");
            exit;
        } else {
            $error = "Update failed. Please try again.";
        }

        $stmt->close();
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Edit Customer</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>

<div class="container mt-4">
    <h3>Edit Customer</h3>

    <?php if ($error): ?>
        <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <form method="post">

        <div class="mb-2">
            <label>Account No</label>
            <input class="form-control"
                   value="<?= htmlspecialchars($customer['Account No']) ?>"
                   disabled>
        </div>

        <div class="mb-2">
            <label>Name</label>
            <input class="form-control"
                   name="name"
                   value="<?= htmlspecialchars($customer['Name']) ?>"
                   required>
        </div>

        <div class="mb-2">
            <label>Address</label>
            <textarea class="form-control"
                      name="address"><?= htmlspecialchars($customer['Address']) ?></textarea>
        </div>

        <div class="mb-2">
            <label>Mobile</label>
            <input class="form-control"
                   name="mobile"
                   value="<?= htmlspecialchars($customer['Mobile No']) ?>">
        </div>

        <div class="mb-2">
            <label>VC Number</label>
            <input class="form-control"
                   name="vc_number"
                   value="<?= htmlspecialchars($customer['VC Number']) ?>">
        </div>

        <div class="mb-2">
            <label>Serial Number</label>
            <input class="form-control"
                   name="serial_number"
                   value="<?= htmlspecialchars($customer['Serial Number']) ?>">
        </div>

        <div class="mb-2">
            <label>Package</label>
            <select name="package_id" class="form-control">
                <?php while ($p = $packages->fetch_assoc()): ?>
                    <option value="<?= $p['id'] ?>"
                        <?= $p['id'] == $customer['Package'] ? 'selected' : '' ?>>
                        <?= htmlspecialchars($p['name']) ?>
                    </option>
                <?php endwhile; ?>
            </select>
        </div>

        <div class="mb-3">
            <label>Status</label>
            <select name="status" class="form-control">
                <option value="Active" <?= $customer['Status']=='Active'?'selected':'' ?>>Active</option>
                <option value="Inactive" <?= $customer['Status']=='Inactive'?'selected':'' ?>>Inactive</option>
            </select>
        </div>

        <button class="btn btn-success">Update Customer</button>
        <a href="customers.php" class="btn btn-secondary">Cancel</a>

    </form>
</div>

</body>
</html>
