<?php
include_once __DIR__ . '/auth_check.php';
include_once __DIR__ . '/config/db.php';

error_reporting(E_ALL);
ini_set('display_errors', 1);

$adminId = $_SESSION['admin_id'];
$message = "";
$skip_logs = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['csv'])) {

    if ($_FILES['csv']['error'] !== 0) {
        die("Upload error");
    }

    $file = fopen($_FILES['csv']['tmp_name'], 'r');

    $rowNo = 0;
    $imported = 0;

    while (($row = fgetcsv($file)) !== false) {
        $rowNo++;

        /* ================= SKIP NON-DATA ROWS ================= */
        if ($rowNo === 1) continue; // "Total Count"
        if ($rowNo === 2) continue; // Header row

        /* ================= MAP COLUMNS ================= */
        $account_no = strtoupper(trim($row[1] ?? ''));
        $serial_no  = trim($row[3] ?? '');
        $vc_number  = trim($row[4] ?? '');
        $name       = trim($row[5] ?? '');
        $address    = trim($row[6] ?? '');
        $mobile     = trim($row[8] ?? '');
        $package    = trim($row[9] ?? '');
        $status     = trim($row[10] ?? 'Active');

        /* ================= CLEAN SCIENTIFIC NUMBERS ================= */
        $serial_no = preg_replace('/\.0+E\+\d+/i', '', $serial_no);
        $vc_number = preg_replace('/\.0+E\+\d+/i', '', $vc_number);
        $mobile    = preg_replace('/\.0+E\+\d+/i', '', $mobile);

        if ($account_no === '' || $name === '') {
            $skip_logs[] = "Row $rowNo skipped (missing account/name)";
            continue;
        }

        if ($package === '') {
            $package = 'DEFAULT';
        }

        /* ================= FIND OR CREATE PACKAGE (ADMIN SAFE) ================= */
        $p = $conn->prepare(
            "SELECT id FROM packages WHERE name=? AND admin_id=? LIMIT 1"
        );
        $p->bind_param("si", $package, $adminId);
        $p->execute();
        $p->store_result();

        if ($p->num_rows === 1) {
            $p->bind_result($package_id);
            $p->fetch();
            $p->close();
        } else {
            $p->close();
            $c = $conn->prepare(
                "INSERT INTO packages (name, status, admin_id)
                 VALUES (?, 'Active', ?)"
            );
            $c->bind_param("si", $package, $adminId);
            $c->execute();
            $package_id = $c->insert_id;
            $c->close();
        }

        /* ================= INSERT / UPDATE CUSTOMER ================= */
        $stmt = $conn->prepare("
            INSERT INTO customers
            (
                `Account No`,
                `Name`,
                `Address`,
                `Mobile No`,
                `VC Number`,
                `Serial Number`,
                `Package`,
                `Status`,
                admin_id
            )
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)
            ON DUPLICATE KEY UPDATE
                `Name`=VALUES(`Name`),
                `Address`=VALUES(`Address`),
                `Mobile No`=VALUES(`Mobile No`),
                `VC Number`=VALUES(`VC Number`),
                `Serial Number`=VALUES(`Serial Number`),
                `Package`=VALUES(`Package`),
                `Status`=VALUES(`Status`)
        ");

        $stmt->bind_param(
            "ssssssisi",
            $account_no,
            $name,
            $address,
            $mobile,
            $vc_number,
            $serial_no,
            $package_id,
            $status,
            $adminId
        );

        if ($stmt->execute()) {
            $imported++;
        } else {
            $skip_logs[] = "Row $rowNo DB error ($account_no)";
        }

        $stmt->close();
    }

    fclose($file);

    $message = "Import completed successfully. Imported: $imported customers";
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Import Customers (CSV)</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>

<div class="container mt-4">
<h3>Import Customers (CSV)</h3>

<?php if ($message): ?>
<div class="alert alert-success"><?= htmlspecialchars($message) ?></div>
<?php endif; ?>

<form method="post" enctype="multipart/form-data">
    <input type="file" name="csv" class="form-control mb-2" accept=".csv" required>
    <button class="btn btn-success">Upload & Import</button>
</form>

<?php if (!empty($skip_logs)): ?>
<hr>
<h5 class="text-danger">Skipped Rows</h5>
<table class="table table-bordered table-sm">
<tr><th>#</th><th>Reason</th></tr>
<?php foreach ($skip_logs as $i => $reason): ?>
<tr>
<td><?= $i + 1 ?></td>
<td><?= htmlspecialchars($reason) ?></td>
</tr>
<?php endforeach; ?>
</table>
<?php endif; ?>
</div>

</body>
</html>
