<?php
include_once __DIR__ . '/auth_check.php';
include_once __DIR__ . '/config/db.php';
require_once __DIR__ . '/qrcode/qrlib.php';

$adminId = $_SESSION['admin_id'];
$role    = $_SESSION['admin_role'];

$id = intval($_GET['id'] ?? 0);
if ($id <= 0) exit('Invalid request');

/* ROLE BASED ACCESS */
if ($role === 'SUPER') {
    $stmt = $conn->prepare(
        "SELECT id, `VC Number` FROM customers WHERE id=?"
    );
    $stmt->bind_param("i", $id);
} else {
    $stmt = $conn->prepare(
        "SELECT id, `VC Number` 
         FROM customers 
         WHERE id=? AND admin_id=?"
    );
    $stmt->bind_param("ii", $id, $adminId);
}

$stmt->execute();
$customer = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$customer) exit('Access denied');

/* QR CONTENT */
$qrData = "VC:{$customer['VC Number']}";

/* OUTPUT QR */
QRcode::png(
    $qrData,
    false,
    QR_ECLEVEL_Q,
    6,
    2
);
