<?php
include_once __DIR__ . '/auth_check.php';
include_once __DIR__ . '/config/db.php';

$adminId = $_SESSION['admin_id'];
$role    = $_SESSION['admin_role'];

$id = intval($_GET['id'] ?? 0);
if ($id <= 0) {
    header("Location: customers.php");
    exit;
}

/*
|--------------------------------------------------------------------------
| TOGGLE CUSTOMER STATUS (ROLE BASED)
|--------------------------------------------------------------------------
| SUPER  -> toggle any customer
| ADMIN  -> toggle only own customers
*/

if ($role === 'SUPER') {

    $sql = "
        UPDATE customers
        SET status = IF(status='Active','Inactive','Active')
        WHERE id = ?
        LIMIT 1
    ";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $id);

} else {

    $sql = "
        UPDATE customers
        SET status = IF(status='Active','Inactive','Active')
        WHERE id = ? AND admin_id = ?
        LIMIT 1
    ";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ii", $id, $adminId);
}

$stmt->execute();
$stmt->close();

// Always redirect back
header("Location: customers.php");
exit;
