<?php
include_once __DIR__ . '/auth_check.php';
include_once __DIR__ . '/config/db.php';

$adminId = $_SESSION['admin_id'];
$role    = $_SESSION['admin_role'];

$id = intval($_GET['id'] ?? 0);
if ($id <= 0) {
    header("Location: customers.php");
    exit;
}

/*
|--------------------------------------------------------------------------
| FETCH CUSTOMER (ROLE BASED)
|--------------------------------------------------------------------------
| SUPER  -> can view any customer
| ADMIN  -> can view only own customers
*/

if ($role === 'SUPER') {

    $sql = "
        SELECT 
            c.id,
            c.`Account No`    AS account_no,
            c.`Name`          AS name,
            c.`Address`       AS address,
            c.`Mobile No`     AS mobile,
            c.`VC Number`     AS vc_number,
            c.`Serial Number` AS serial_number,
            c.`Status`        AS status,
            p.name            AS package_name,
            p.price           AS package_price
        FROM customers c
        LEFT JOIN packages p ON c.`Package` = p.id
        WHERE c.id = ?
        LIMIT 1
    ";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $id);

} else {

    $sql = "
        SELECT 
            c.id,
            c.`Account No`    AS account_no,
            c.`Name`          AS name,
            c.`Address`       AS address,
            c.`Mobile No`     AS mobile,
            c.`VC Number`     AS vc_number,
            c.`Serial Number` AS serial_number,
            c.`Status`        AS status,
            p.name            AS package_name,
            p.price           AS package_price
        FROM customers c
        LEFT JOIN packages p ON c.`Package` = p.id
        WHERE c.id = ? AND c.admin_id = ?
        LIMIT 1
    ";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ii", $id, $adminId);
}

$stmt->execute();
$customer = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$customer) {
    // Either customer doesn't exist OR access denied
    header("Location: customers.php");
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>View Customer</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>

<div class="container mt-4">

    <div class="d-flex justify-content-between align-items-center mb-3">
        <h3>View Customer</h3>
        <a href="customers.php" class="btn btn-secondary">Back</a>
    </div>

    <table class="table table-bordered">
        <tr>
            <th width="30%">Customer ID</th>
            <td>CUST-<?= str_pad($customer['id'], 5, '0', STR_PAD_LEFT) ?></td>
        </tr>
        <tr>
            <th>Account No</th>
            <td><?= htmlspecialchars($customer['account_no']) ?></td>
        </tr>
        <tr>
            <th>Name</th>
            <td><?= htmlspecialchars($customer['name']) ?></td>
        </tr>
        <tr>
            <th>Address</th>
            <td><?= nl2br(htmlspecialchars($customer['address'])) ?></td>
        </tr>
        <tr>
            <th>Mobile</th>
            <td><?= htmlspecialchars($customer['mobile']) ?></td>
        </tr>
        <tr>
            <th>VC Number</th>
            <td><?= htmlspecialchars($customer['vc_number']) ?></td>
        </tr>
        <tr>
            <th>Serial Number</th>
            <td><?= htmlspecialchars($customer['serial_number']) ?></td>
        </tr>
        <tr>
            <th>Package</th>
            <td><?= htmlspecialchars($customer['package_name'] ?? 'N/A') ?></td>
        </tr>
        <tr>
            <th>Package Price</th>
            <td>₹<?= number_format((float)($customer['package_price'] ?? 0), 2) ?></td>
        </tr>
        <tr>
            <th>Status</th>
            <td>
                <span class="badge <?= $customer['status'] === 'Active' ? 'bg-success' : 'bg-danger' ?>">
                    <?= htmlspecialchars($customer['status']) ?>
                </span>
            </td>
        </tr>
    </table>

    <div class="mt-3">
        <a href="customer_edit.php?id=<?= $customer['id'] ?>" class="btn btn-warning">
            Edit Customer
        </a>
    </div>

</div>

</body>
</html>
