<?php
include_once __DIR__ . '/auth_check.php';
include_once __DIR__ . '/config/db.php';


/* ================= PAGE TITLE ================= */
$pageTitle = "Customer";

/* ================= HEADER ================= */
include_once __DIR__ . "/layout/header.php";

$adminId = $_SESSION['admin_id'];
$role    = $_SESSION['admin_role'];

/* ================= PAGINATION ================= */
$limit = 25;
$page  = isset($_GET['page']) && $_GET['page'] > 0 ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $limit;

/* ================= COUNT TOTAL ================= */
if ($role === 'SUPER') {
    $countSql = "SELECT COUNT(*) FROM customers";
    $countStmt = $conn->prepare($countSql);
} else {
    $countSql = "SELECT COUNT(*) FROM customers WHERE admin_id=?";
    $countStmt = $conn->prepare($countSql);
    $countStmt->bind_param("i", $adminId);
}

$countStmt->execute();
$countStmt->bind_result($totalRows);
$countStmt->fetch();
$countStmt->close();

$totalPages = ceil($totalRows / $limit);

/* ================= FETCH CUSTOMERS ================= */
if ($role === 'SUPER') {

    $sql = "
        SELECT 
            c.id,
            c.`Account No`   AS account_no,
            c.`Name`         AS name,
            c.`Address`      AS address,
            c.`Mobile No`    AS mobile,
            c.`VC Number`    AS vc_number,
            c.`Status`       AS status,
            p.name           AS package_name,
            p.price          AS package_amount,

            (
                SELECT IFNULL(SUM(b.amount - b.paid_amount), 0)
                FROM bills b
                WHERE b.customer_id = c.id
            ) AS carry_balance

        FROM customers c
        LEFT JOIN packages p ON c.`Package` = p.id
        ORDER BY c.id DESC
        LIMIT ? OFFSET ?
    ";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ii", $limit, $offset);

} else {

    $sql = "
        SELECT 
            c.id,
            c.`Account No`   AS account_no,
            c.`Name`         AS name,
            c.`Address`      AS address,
            c.`Mobile No`    AS mobile,
            c.`VC Number`    AS vc_number,
            c.`Status`       AS status,
            p.name           AS package_name,
            p.price          AS package_amount,

            (
                SELECT IFNULL(SUM(b.amount - b.paid_amount), 0)
                FROM bills b
                WHERE b.customer_id = c.id
            ) AS carry_balance

        FROM customers c
        LEFT JOIN packages p ON c.`Package` = p.id
        WHERE c.admin_id = ?
        ORDER BY c.id DESC
        LIMIT ? OFFSET ?
    ";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("iii", $adminId, $limit, $offset);
}

$stmt->execute();
$result = $stmt->get_result();

/* UI SERIAL NUMBER */
$sl = $offset + 1;
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Customers</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <style>
        
        /* ================= PAGE TITLE BAR ================= */
.customer-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 18px;
}

.customer-header h3 {
    margin: 0;
    font-weight: 600;
}

/* ================= ACTION BUTTONS ================= */
.customer-header .btn {
    margin-left: 6px;
}

/* ================= TABLE ================= */
.table {
    background: #ffffff;
    border-radius: 10px;
    overflow: hidden;
}

.table thead th {
    font-size: 13px;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.3px;
}

.table tbody td {
    font-size: 14px;
    vertical-align: middle;
    white-space: nowrap;
}

/* ================= ADDRESS COLUMN ================= */
.table td:nth-child(4) {
    max-width: 220px;
    white-space: normal;
}

/* ================= STATUS BADGE ================= */
.badge {
    padding: 6px 10px;
    font-size: 12px;
    border-radius: 999px;
}

/* ================= ACTION BUTTONS ================= */
.table .btn-sm {
    font-size: 12px;
    padding: 4px 8px;
    margin: 2px 1px;
}
/* Allow package column to wrap */
.table td:nth-child(7) {
    white-space: normal;
    max-width: 160px;
    line-height: 1.4;
}


/* ================= BALANCE COLORS ================= */
.text-success {
    color: #16A34A !important;
}
.text-danger {
    color: #DC2626 !important;
}

/* ================= TABLE HOVER ================= */
.table tbody tr:hover {
    background: #F8FAFC;
}

/* ================= PAGINATION ================= */
.pagination .page-link {
    color: #334155;
    border-radius: 6px;
    margin: 0 3px;
}

.pagination .page-item.active .page-link {
    background: #2563EB;
    border-color: #2563EB;
}

/* ================= MOBILE ================= */
@media (max-width: 768px) {
    .customer-header {
        flex-direction: column;
        align-items: flex-start;
        gap: 10px;
    }

    .table-responsive {
        border-radius: 10px;
    }

    .table td {
        font-size: 13px;
    }
}

    </style>
    <main class="main-content">

<div class="container-fluid mt-4">

    <div class="d-flex justify-content-between align-items-center mb-3">
        <h3>Customers</h3>
        <div>
            <a href="customer_add.php" class="btn btn-primary">+ Add Customer</a>
            <a href="customer_import.php" class="btn btn-success">Import Customers</a>
        </div>
    </div>

    <div class="table-responsive">
        <table class="table table-bordered table-striped align-middle">
            <thead class="table-dark">
            <tr>
                <th>SL</th>
                <th>Account No</th>
                <th>Name</th>
                <th>Address</th>
                <th>Mobile</th>
                <th>VC No</th>
                <th>Package</th>
                <th>Amount</th>
                <th>Balance</th>
                <th>Status</th>
                <th style="width:260px;">Actions</th>
            </tr>
            </thead>
            <tbody>

            <?php if ($result && $result->num_rows > 0): ?>
                <?php while ($row = $result->fetch_assoc()): ?>
                    <tr>
                        <td><?= $sl++ ?></td>
                        <td><?= htmlspecialchars($row['account_no']) ?></td>
                        <td><?= htmlspecialchars($row['name']) ?></td>
                        <td><?= htmlspecialchars($row['address']) ?></td>
                        <td><?= htmlspecialchars($row['mobile']) ?></td>
                        <td><?= htmlspecialchars($row['vc_number']) ?></td>
                        <td><?= htmlspecialchars($row['package_name'] ?? '-') ?></td>
                        <td>₹<?= number_format((float)$row['package_amount'], 2) ?></td>

                        <td>
                            <?php if ($row['carry_balance'] < 0): ?>
                                <span class="text-success fw-bold">
                                    + ₹<?= number_format(abs($row['carry_balance']), 2) ?>
                                </span>
                            <?php elseif ($row['carry_balance'] > 0): ?>
                                <span class="text-danger fw-bold">
                                    − ₹<?= number_format($row['carry_balance'], 2) ?>
                                </span>
                            <?php else: ?>
                                ₹0.00
                            <?php endif; ?>
                        </td>

                        <td>
                            <span class="badge <?= $row['status'] === 'Active' ? 'bg-success' : 'bg-danger' ?>">
                                <?= htmlspecialchars($row['status']) ?>
                            </span>
                        </td>

                        <td>
                            <a href="payment.php?customer_id=<?= $row['id'] ?>" class="btn btn-sm btn-success">Pay</a>
                           
                            <a href="customer_view.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-primary">View</a>
                            <a href="customer_edit.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-warning">Edit</a>
                            <a href="customer_toggle.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-info">Toggle</a>
                            <a href="customer_delete.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-danger"
                               onclick="return confirm('Delete this customer permanently?');">Delete</a>
                            <a href="customer_bills.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-secondary">Bills</a>
                        </td>
                    </tr>
                <?php endwhile; ?>
            <?php else: ?>
                <tr>
                    <td colspan="11" class="text-center">No customers found</td>
                </tr>
            <?php endif; ?>

            </tbody>
        </table>
    </div>

    <!-- PAGINATION -->
    <?php if ($totalPages > 1): ?>
        <nav>
            <ul class="pagination justify-content-center">
                <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                    <li class="page-item <?= $i == $page ? 'active' : '' ?>">
                        <a class="page-link" href="?page=<?= $i ?>">
                            <?= $i ?>
                        </a>
                    </li>
                <?php endfor; ?>
            </ul>
        </nav>
    <?php endif; ?>

</div>

</main>


<?php include_once __DIR__ . "/layout/footer.php"; ?>

</body>
</html>
