<?php
include_once __DIR__ . "/auth_check.php";
include_once __DIR__ . "/config/db.php";

/* ================= PAGE TITLE ================= */
$pageTitle = "DashBoard";

/* ================= HEADER ================= */
include_once __DIR__ . "/layout/header.php";

error_reporting(E_ALL);
ini_set('display_errors', 1);

$adminId = $_SESSION['admin_id'];
$role    = $_SESSION['admin_role'];

$billMonth = (int)date('n');
$billYear  = (int)date('Y');

/* ================= CUSTOMER FILTER ================= */
$whereAdmin = ($role === 'SUPER') ? "" : " AND admin_id=$adminId";

/* ================= TOTAL CUSTOMERS ================= */
$totalCustomers = $conn->query("
    SELECT COUNT(*) total
    FROM customers
    WHERE 1=1 $whereAdmin
")->fetch_assoc()['total'];

/* ================= ACTIVE CUSTOMERS ================= */
$activeCustomers = $conn->query("
    SELECT COUNT(*) total
    FROM customers
    WHERE Status='Active' $whereAdmin
")->fetch_assoc()['total'];

/* ================= INACTIVE CUSTOMERS ================= */
$inactiveCustomers = $conn->query("
    SELECT COUNT(*) total
    FROM customers
    WHERE Status!='Active' $whereAdmin
")->fetch_assoc()['total'];

/* ================= PAID CUSTOMERS ================= */
$paidCustomers = $conn->query("
    SELECT COUNT(DISTINCT b.customer_id) total
    FROM bills b
    JOIN customers c ON b.customer_id = c.id
    WHERE b.bill_month = $billMonth
      AND b.bill_year  = $billYear
      AND b.amount <= IFNULL(b.paid_amount,0)
      $whereAdmin
")->fetch_assoc()['total'];

/* ================= UNPAID CUSTOMERS ================= */
$unpaidCustomers = $conn->query("
    SELECT COUNT(DISTINCT b.customer_id) total
    FROM bills b
    JOIN customers c ON b.customer_id = c.id
    WHERE b.bill_month = $billMonth
      AND b.bill_year  = $billYear
      AND b.amount > IFNULL(b.paid_amount,0)
      $whereAdmin
")->fetch_assoc()['total'];

/* ================= COLLECTION FILTER ================= */
$wherePaymentAdmin = ($role === 'SUPER') ? "" : " AND c.admin_id=$adminId";

/* ================= MONTHLY COLLECTION ================= */
$monthlyCollection = $conn->query("
    SELECT IFNULL(SUM(p.amount),0) total
    FROM payments p
    JOIN bills b ON p.bill_id = b.id
    JOIN customers c ON b.customer_id = c.id
    WHERE MONTH(p.payment_date) = MONTH(CURDATE())
      AND YEAR(p.payment_date)  = YEAR(CURDATE())
      $wherePaymentAdmin
")->fetch_assoc()['total'];

/* ================= TODAY COLLECTION ================= */
$dailyCollection = $conn->query("
    SELECT IFNULL(SUM(p.amount),0) total
    FROM payments p
    JOIN bills b ON p.bill_id = b.id
    JOIN customers c ON b.customer_id = c.id
    WHERE DATE(p.payment_date) = CURDATE()
      $wherePaymentAdmin
")->fetch_assoc()['total'];

/* ================= PENDING AMOUNT ================= */
$pendingAmount = $conn->query("
    SELECT IFNULL(SUM(b.amount - IFNULL(b.paid_amount,0)),0) total
    FROM bills b
    JOIN customers c ON b.customer_id = c.id
    WHERE b.amount > IFNULL(b.paid_amount,0)
      $whereAdmin
")->fetch_assoc()['total'];
?>

<!-- ================= MAIN CONTENT ================= -->
<main class="main-content">

<style>
/* ===== DASHBOARD GRID ===== */
.dashboard-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(220px, 1fr));
    gap: 20px;
    margin-top: 20px;
}

/* ===== DASHBOARD CARD ===== */
.dashboard-card {
    background: #ffffff;
    border-radius: 14px;
    padding: 20px;
    box-shadow: 0 10px 25px rgba(0,0,0,0.06);
    transition: transform .2s ease;
}

.dashboard-card:hover {
    transform: translateY(-4px);
}

.dashboard-card h6 {
    margin: 0;
    font-size: 13px;
    color: #64748B;
    font-weight: 600;
}

.dashboard-card h3 {
    margin-top: 8px;
    font-size: 26px;
    font-weight: 700;
}

/* ===== COLORS ===== */
.text-success { color: #22C55E; }
.text-danger  { color: #EF4444; }
.text-warning { color: #F59E0B; }
.text-primary { color: #3B82F6; }
.text-info    { color: #0EA5E9; }
.text-muted   { color: #64748B; }
</style>

<div class="dashboard-grid">

    <div class="dashboard-card">
        <h6>Total Customers</h6>
        <h3 class="text-primary"><?= $totalCustomers ?></h3>
    </div>

    <div class="dashboard-card">
        <h6>Active Customers</h6>
        <h3 class="text-success"><?= $activeCustomers ?></h3>
    </div>

    <div class="dashboard-card">
        <h6>Inactive Customers</h6>
        <h3 class="text-muted"><?= $inactiveCustomers ?></h3>
    </div>

    <div class="dashboard-card">
        <h6>Paid Customers (<?= date('F') ?>)</h6>
        <h3 class="text-success"><?= $paidCustomers ?></h3>
    </div>

    <div class="dashboard-card">
        <h6>Unpaid Customers (<?= date('F') ?>)</h6>
        <h3 class="text-danger"><?= $unpaidCustomers ?></h3>
    </div>

    <div class="dashboard-card">
        <h6>Monthly Collection</h6>
        <h3 class="text-info">₹<?= number_format($monthlyCollection,2) ?></h3>
    </div>

    <div class="dashboard-card">
        <h6>Today Collection</h6>
        <h3 class="text-warning">₹<?= number_format($dailyCollection,2) ?></h3>
    </div>

    <div class="dashboard-card">
        <h6>Pending Amount</h6>
        <h3 class="text-danger">₹<?= number_format($pendingAmount,2) ?></h3>
    </div>

</div>

</main>


<?php include_once __DIR__ . "/layout/footer.php"; ?>
