<?php
if (!isset($_SESSION)) session_start();
$adminName = $_SESSION['admin_name'] ?? 'Admin';
$pageTitle = $pageTitle ?? 'Admin Panel';
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title><?= htmlspecialchars($pageTitle) ?></title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600&display=swap" rel="stylesheet">
<link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">

<style>
/* ===== RESET ===== */
* { box-sizing: border-box; font-family: 'Inter', sans-serif; }
html, body { height: 100%; }
body { margin: 0; background: #F4F6FA; }

/* ===== LAYOUT ===== */
.page-wrapper { min-height: 100vh; display: flex; }

/* ===== SIDEBAR ===== */
.sidebar {
    position: fixed;
    top: 0; left: 0;
    width: 240px; height: 100vh;
    background: linear-gradient(180deg,#0F172A,#020617);
    color: #fff;
    padding-top: 20px;
    z-index: 1000;
    transition: transform .3s ease;
}
.sidebar h3 { padding: 0 20px; margin-bottom: 20px; }

.sidebar a {
    display: flex;
    align-items: center;
    gap: 10px;
    padding: 14px 20px;
    color: #CBD5E1;
    text-decoration: none;
    font-size: 14px;
    cursor: pointer;
}
.sidebar a:hover { background:#1E293B; color:#fff; }

/* ===== SUBMENU ===== */
.submenu {
    display: none;
    background: #020617;
}
.submenu a {
    padding-left: 48px;
    font-size: 13px;
    color: #94A3B8;
}
.submenu a:hover {
    color:#fff;
}

/* ===== HEADER ===== */
.header {
    position: fixed;
    top: 0; left: 240px; right: 0;
    height: 60px;
    background: #fff;
    border-bottom: 1px solid #E5E7EB;
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 0 20px;
    z-index: 900;
    transition: left .3s ease;
}
.header-left { display:flex; align-items:center; gap:12px; }
.menu-btn { cursor:pointer; font-size:26px; }
.header-title { font-size:18px; font-weight:600; margin:0; }
.header-right { display:flex; align-items:center; gap:8px; }

/* ===== CONTENT ===== */
.content-wrapper {
    margin-left: 240px;
    width: calc(100% - 240px);
    min-height: 100vh;
    display: flex;
    flex-direction: column;
    transition: margin-left .3s ease;
}
.main-content {
    flex: 1;
    margin-top: 60px;
    padding: 24px ;
}

/* ===== FOOTER ===== */
.footer {
    background:#F4F6FA;
    border-top:1px solid #E5E7EB;
    padding:12px;
    font-size:13px;
    color:#64748B;
    text-align:center;
}

/* ===== COLLAPSE ===== */
body.sidebar-collapsed .sidebar { transform:translateX(-240px); }
body.sidebar-collapsed .header { left:0; }
body.sidebar-collapsed .content-wrapper {
    margin-left:0; width:100%;
}

/* ===== MOBILE ===== */
@media(max-width:768px){
    .header{left:0;}
    .content-wrapper{margin-left:0;width:100%;}
}
</style>
</head>

<body>

<div class="page-wrapper">

<!-- ===== SIDEBAR ===== -->
<div class="sidebar">
    <h3>Cable Admin</h3>

    <a href="../admin/dashboard.php" onclick="sidebarItemClicked()">
        <span class="material-icons">dashboard</span>Dashboard
    </a>

    <a href="../admin/customers.php" onclick="sidebarItemClicked()">
        <span class="material-icons">people</span>Customers
    </a>

    <a href="../admin/bills_generate.php" onclick="sidebarItemClicked()">
        <span class="material-icons">receipt</span>Generate Bills
    </a>

    <a href="../admin/bills.php" onclick="sidebarItemClicked()">
        <span class="material-icons">description</span>Bills
    </a>

    <!-- REPORTS MENU -->
    <a onclick="toggleSubmenu('reportMenu')">
        <span class="material-icons">bar_chart</span>Reports
        <span class="material-icons" style="margin-left:auto;">expand_more</span>
    </a>

    <div class="submenu" id="reportMenu">
        <a href="../admin/reports/collection_reports.php" onclick="sidebarItemClicked()">
            Collection Reports
        </a>
    </div>

    <a href="../logout.php">
        <span class="material-icons">logout</span>Logout
    </a>
</div>

<!-- ===== CONTENT WRAPPER ===== -->
<div class="content-wrapper">

<!-- ===== HEADER ===== -->
<div class="header">
    <div class="header-left">
        <span class="material-icons menu-btn" onclick="toggleSidebar()">menu</span>
        <h3 class="header-title"><?= htmlspecialchars($pageTitle) ?></h3>
    </div>
    <div class="header-right">
        <span class="material-icons">account_circle</span>
        <?= htmlspecialchars($adminName) ?>
    </div>
</div>

<script>
function toggleSidebar(){
    document.body.classList.toggle('sidebar-collapsed');
    localStorage.setItem(
        'sidebar_state',
        document.body.classList.contains('sidebar-collapsed') ? 'collapsed' : 'open'
    );
}

function toggleSubmenu(id){
    document.querySelectorAll('.submenu').forEach(m=>{
        if(m.id !== id) m.style.display = 'none';
    });
    const el = document.getElementById(id);
    el.style.display = el.style.display === 'block' ? 'none' : 'block';
}

function sidebarItemClicked(){
    document.querySelectorAll('.submenu').forEach(m => m.style.display = 'none');
    if (!document.body.classList.contains('sidebar-collapsed')) {
        document.body.classList.add('sidebar-collapsed');
        localStorage.setItem('sidebar_state', 'collapsed');
    }
}

document.addEventListener('DOMContentLoaded', () => {
    if (localStorage.getItem('sidebar_state') === 'collapsed') {
        document.body.classList.add('sidebar-collapsed');
    }
});
</script>
