<?php
session_start();

// ====== DEV DEBUG (disable in production) ======
if (defined('DEBUG') && DEBUG) {
    ini_set('display_errors', 1);
    error_reporting(E_ALL);
}

include_once __DIR__ . '/session.php';
include_once __DIR__ . '/config/db.php';

// Already logged in
if (!empty($_SESSION['admin_id'])) {
    header('Location: dashboard.php');
    exit;
}

$error = '';
$usernameInput = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $usernameInput = trim($_POST['username'] ?? '');
    $password      = trim($_POST['password'] ?? '');

    if ($usernameInput === '' || $password === '') {
        $error = 'Username and Password are required';
    } else {

        $stmt = $conn->prepare(
            'SELECT id, username, password, role 
             FROM admins 
             WHERE username = ? 
             LIMIT 1'
        );

        if (!$stmt) {
            $error = 'Internal error';
        } else {

            $stmt->bind_param('s', $usernameInput);
            $stmt->execute();
            $stmt->store_result();

            if ($stmt->num_rows === 1) {

                $stmt->bind_result($id, $db_username, $db_password, $db_role);
                $stmt->fetch();

                $login_ok     = false;
                $needs_rehash = false;

                // ====== PASSWORD CHECK ======
                if (password_verify($password, $db_password)) {
                    $login_ok = true;
                } elseif (md5($password) === $db_password) {
                    // legacy MD5 support
                    $login_ok     = true;
                    $needs_rehash = true;
                }

                $stmt->free_result();
                $stmt->close();

                if ($login_ok) {

                    // Secure session
                    session_regenerate_id(true);

                    $_SESSION['admin_id']       = $id;
                    $_SESSION['admin_username'] = $db_username;
                    $_SESSION['admin_role']     = $db_role; // ⭐ IMPORTANT

                    // Upgrade MD5 password
                    if ($needs_rehash) {
                        $newHash = password_hash($password, PASSWORD_DEFAULT);
                        $u = $conn->prepare('UPDATE admins SET password=? WHERE id=?');
                        if ($u) {
                            $u->bind_param('si', $newHash, $id);
                            $u->execute();
                            $u->close();
                        }
                    }

                    header('Location: dashboard.php');
                    exit;

                } else {
                    $error = 'Invalid username or password';
                }

            } else {
                $stmt->free_result();
                $stmt->close();
                $error = 'Invalid username or password';
            }
        }
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Admin Login</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background: #f2f2f2;
        }
        .login-box {
            width: 350px;
            margin: 100px auto;
            background: white;
            padding: 20px;
            border-radius: 6px;
            box-shadow: 0 0 10px #ccc;
        }
        input, button {
            width: 100%;
            padding: 10px;
            margin-top: 10px;
        }
        .error {
            background: #ffe0e0;
            color: red;
            padding: 10px;
            margin-bottom: 10px;
            text-align: center;
        }
        .note {
            font-size: 0.85em;
            color: #666;
            margin-top: 10px;
        }
    </style>
</head>
<body>

<div class="login-box">
    <h2>Admin Login</h2>

    <?php if ($error): ?>
        <div class="error"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <form method="post">
        <input type="text" name="username" placeholder="Username"
               value="<?= htmlspecialchars($usernameInput) ?>" required>
        <input type="password" name="password" placeholder="Password" required>
        <button type="submit">Login</button>
    </form>

    <div class="note">
        Legacy passwords will be upgraded automatically.
    </div>
</div>

</body>
</html>
