<?php
include_once __DIR__ . '/../auth_check.php';
include_once __DIR__ . '/../config/db.php';

$adminId = $_SESSION['admin_id'];
$role    = $_SESSION['admin_role'];

// Filters
$from = $_GET['from'] ?? date('Y-m-01');
$to   = $_GET['to'] ?? date('Y-m-d');
$action = $_GET['action'] ?? '';

/*
|--------------------------------------------------------------------------
| ROLE BASED CONDITION
|--------------------------------------------------------------------------
*/
$whereExtra = "";
$params     = [$from, $to];
$types      = "ss";

if ($role !== 'SUPER') {
    $whereExtra .= " AND l.admin_id = ?";
    $params[]    = $adminId;
    $types      .= "i";
}

if (!empty($action)) {
    $whereExtra .= " AND l.action = ?";
    $params[]    = $action;
    $types      .= "s";
}

/*
|--------------------------------------------------------------------------
| FETCH ADMIN LOGS
|--------------------------------------------------------------------------
*/
$sql = "
    SELECT
        l.id,
        l.action,
        l.reference_type,
        l.reference_id,
        l.description,
        l.created_at,
        a.username AS admin_name
    FROM admin_logs l
    LEFT JOIN admins a ON a.id = l.admin_id
    WHERE DATE(l.created_at) BETWEEN ? AND ?
    $whereExtra
    ORDER BY l.created_at DESC
";

$stmt = $conn->prepare($sql);
$stmt->bind_param($types, ...$params);
$stmt->execute();
$result = $stmt->get_result();
?>

<!DOCTYPE html>
<html>
<head>
    <title>Admin Activity Logs</title>
    <style>
        table { width:100%; border-collapse: collapse; }
        th, td { padding:10px; border:1px solid #ddd; }
        th { background:#f4f6fa; }

        .DELETE { color:#c62828; font-weight:bold; }
        .CREATE { color:#2e7d32; font-weight:bold; }
        .UPDATE { color:#ef6c00; font-weight:bold; }
    </style>
</head>
<body>

<h2>Admin Activity Logs</h2>

<form method="get">
    From:
    <input type="date" name="from" value="<?= htmlspecialchars($from) ?>">
    To:
    <input type="date" name="to" value="<?= htmlspecialchars($to) ?>">

    Action:
    <select name="action">
        <option value="">All</option>
        <option value="CREATE" <?= $action === 'CREATE' ? 'selected' : '' ?>>CREATE</option>
        <option value="UPDATE" <?= $action === 'UPDATE' ? 'selected' : '' ?>>UPDATE</option>
        <option value="DELETE" <?= $action === 'DELETE' ? 'selected' : '' ?>>DELETE</option>
    </select>

    <button type="submit">Filter</button>
</form>

<table>
    <tr>
        <th>Date & Time</th>
        <th>Admin</th>
        <th>Action</th>
        <th>Type</th>
        <th>Reference ID</th>
        <th>Description</th>
    </tr>

    <?php while ($row = $result->fetch_assoc()): ?>
        <tr>
            <td><?= date('d-m-Y H:i:s', strtotime($row['created_at'])) ?></td>
            <td><?= htmlspecialchars($row['admin_name']) ?></td>
            <td class="<?= $row['action'] ?>"><?= $row['action'] ?></td>
            <td><?= $row['reference_type'] ?></td>
            <td><?= $row['reference_id'] ?></td>
            <td><?= htmlspecialchars($row['description']) ?></td>
        </tr>
    <?php endwhile; ?>
</table>

</body>
</html>
