<?php
include_once __DIR__ . '/auth_check.php';
include_once __DIR__ . '/config/db.php';

$error = '';
$adminId = $_SESSION['admin_id'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $name   = trim($_POST['name']);
    $price  = floatval($_POST['price']);
    $status = $_POST['status'];

    if ($name === '') {
        $error = "Package name is required";
    } elseif ($price < 0) {
        $error = "Invalid price";
    } else {

        $stmt = $conn->prepare("
            INSERT INTO packages (admin_id, name, price, status)
            VALUES (?, ?, ?, ?)
        ");
        $stmt->bind_param("isds", $adminId, $name, $price, $status);

        if ($stmt->execute()) {
            header("Location: packages.php");
            exit;
        } else {
            $error = "Database error: " . $conn->error;
        }

        $stmt->close();
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Add Package</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>

<div class="container mt-4">

<h3>Add Package</h3>

<?php if ($error): ?>
<div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
<?php endif; ?>

<form method="post">
    <div class="mb-2">
        <label>Package Name</label>
        <input class="form-control" name="name" required>
    </div>

    <div class="mb-2">
        <label>Price (₹)</label>
        <input class="form-control" name="price" type="number" step="0.01" min="0" required>
    </div>

    <div class="mb-3">
        <label>Status</label>
        <select name="status" class="form-control">
            <option value="Active">Active</option>
            <option value="Inactive">Inactive</option>
        </select>
    </div>

    <button class="btn btn-success">Save Package</button>
    <a href="packages.php" class="btn btn-secondary">Cancel</a>
</form>

</div>
</body>
</html>
