<?php
include_once __DIR__ . '/auth_check.php';
include_once __DIR__ . '/config/db.php';

$adminId = $_SESSION['admin_id'];
$role    = $_SESSION['admin_role'];

$id = intval($_GET['id'] ?? 0);

if ($id <= 0) {
    header("Location: packages.php");
    exit;
}

/* ================= OWNERSHIP CHECK ================= */
if ($role === 'SUPER') {

    $pkgStmt = $conn->prepare("SELECT id FROM packages WHERE id = ?");
    $pkgStmt->bind_param("i", $id);

} else {

    $pkgStmt = $conn->prepare(
        "SELECT id FROM packages WHERE id = ? AND admin_id = ?"
    );
    $pkgStmt->bind_param("ii", $id, $adminId);
}

$pkgStmt->execute();
$pkg = $pkgStmt->get_result()->fetch_assoc();
$pkgStmt->close();

if (!$pkg) {
    // Not your package
    header("Location: packages.php?error=unauthorized");
    exit;
}

/* ================= CHECK IF USED ================= */
if ($role === 'SUPER') {

    $check = $conn->prepare(
        "SELECT COUNT(*) FROM customers WHERE `Package` = ?"
    );
    $check->bind_param("i", $id);

} else {

    $check = $conn->prepare(
        "SELECT COUNT(*) 
         FROM customers 
         WHERE `Package` = ? AND admin_id = ?"
    );
    $check->bind_param("ii", $id, $adminId);
}

$check->execute();
$check->bind_result($count);
$check->fetch();
$check->close();

if ($count > 0) {
    header("Location: packages.php?error=used");
    exit;
}

/* ================= DELETE PACKAGE ================= */
$stmt = $conn->prepare("DELETE FROM packages WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$stmt->close();

header("Location: packages.php?deleted=1");
exit;
