<?php
include_once __DIR__ . '/auth_check.php';
include_once __DIR__ . '/config/db.php';

$adminId = $_SESSION['admin_id'];
$role    = $_SESSION['admin_role'];

$id = intval($_GET['id'] ?? 0);

if ($id <= 0) {
    header("Location: packages.php");
    exit;
}

/* ================= FETCH PACKAGE WITH OWNERSHIP ================= */
if ($role === 'SUPER') {

    $stmt = $conn->prepare("SELECT * FROM packages WHERE id = ?");
    $stmt->bind_param("i", $id);

} else {

    $stmt = $conn->prepare(
        "SELECT * FROM packages WHERE id = ? AND admin_id = ?"
    );
    $stmt->bind_param("ii", $id, $adminId);
}

$stmt->execute();
$pkg = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$pkg) {
    // Not found OR not your package
    header("Location: packages.php?error=unauthorized");
    exit;
}

/* ================= UPDATE PACKAGE ================= */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $name   = trim($_POST['name']);
    $price  = floatval($_POST['price']);
    $status = $_POST['status'];

    if ($name === '') {
        $error = "Package name required";
    } elseif ($price < 0) {
        $error = "Invalid price";
    } else {

        if ($role === 'SUPER') {

            $u = $conn->prepare(
                "UPDATE packages SET name=?, price=?, status=? WHERE id=?"
            );
            $u->bind_param("sdsi", $name, $price, $status, $id);

        } else {

            $u = $conn->prepare(
                "UPDATE packages 
                 SET name=?, price=?, status=? 
                 WHERE id=? AND admin_id=?"
            );
            $u->bind_param("sdsii", $name, $price, $status, $id, $adminId);
        }

        if ($u->execute()) {
            header("Location: packages.php?updated=1");
            exit;
        } else {
            $error = "Update failed";
        }

        $u->close();
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Edit Package</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>

<div class="container mt-4">

    <h3>
        Edit Package
        <?php if ($role === 'SUPER'): ?>
            <span class="badge bg-danger ms-2">SUPER ADMIN</span>
        <?php endif; ?>
    </h3>

    <?php if (!empty($error)): ?>
        <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <form method="post">

        <div class="mb-2">
            <label>Package Name</label>
            <input class="form-control"
                   name="name"
                   value="<?= htmlspecialchars($pkg['name']) ?>"
                   required>
        </div>

        <div class="mb-2">
            <label>Price (₹)</label>
            <input class="form-control"
                   name="price"
                   type="number"
                   step="0.01"
                   min="0"
                   value="<?= htmlspecialchars($pkg['price']) ?>"
                   required>
        </div>

        <div class="mb-3">
            <label>Status</label>
            <select name="status" class="form-control">
                <option value="Active" <?= $pkg['status']=='Active'?'selected':'' ?>>Active</option>
                <option value="Inactive" <?= $pkg['status']=='Inactive'?'selected':'' ?>>Inactive</option>
            </select>
        </div>

        <button class="btn btn-success">Update</button>
        <a href="packages.php" class="btn btn-secondary">Cancel</a>
    </form>

</div>

</body>
</html>
