<?php
include_once __DIR__ . '/auth_check.php';
include_once __DIR__ . '/config/db.php';

$adminId = $_SESSION['admin_id'];
$role    = $_SESSION['admin_role'];

/* ================= FETCH PACKAGES ================= */
if ($role === 'SUPER') {

    $result = $conn->query("
        SELECT p.*, a.username AS admin_name
        FROM packages p
        LEFT JOIN admins a ON p.admin_id = a.id
        ORDER BY p.id DESC
    ");

} else {

    $stmt = $conn->prepare("
        SELECT *
        FROM packages
        WHERE admin_id = ?
        ORDER BY id DESC
    ");
    $stmt->bind_param("i", $adminId);
    $stmt->execute();
    $result = $stmt->get_result();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Packages</title>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>

<div class="container mt-4">

    <div class="d-flex justify-content-between align-items-center mb-3">
        <h3>
            Packages
            <?php if ($role === 'SUPER'): ?>
                <span class="badge bg-danger ms-2">SUPER ADMIN</span>
            <?php endif; ?>
        </h3>
        <a href="package_add.php" class="btn btn-primary">+ Add Package</a>
    </div>

    <!-- STATUS MESSAGES -->
    <?php if (isset($_GET['deleted'])): ?>
        <div class="alert alert-success">Package deleted successfully.</div>
    <?php endif; ?>

    <?php if (isset($_GET['updated'])): ?>
        <div class="alert alert-success">Package updated successfully.</div>
    <?php endif; ?>

    <?php if (isset($_GET['error']) && $_GET['error'] === 'used'): ?>
        <div class="alert alert-danger">
            Cannot delete package — it is assigned to one or more customers.
        </div>
    <?php endif; ?>

    <?php if (isset($_GET['error']) && $_GET['error'] === 'unauthorized'): ?>
        <div class="alert alert-danger">
            Unauthorized action.
        </div>
    <?php endif; ?>

    <div class="table-responsive">
        <table class="table table-bordered table-striped align-middle">
            <thead class="table-dark">
                <tr>
                    <th>ID</th>
                    <?php if ($role === 'SUPER'): ?>
                        <th>Admin</th>
                    <?php endif; ?>
                    <th>Package Name</th>
                    <th>Price (₹)</th>
                    <th>Status</th>
                    <th style="width:180px;">Actions</th>
                </tr>
            </thead>
            <tbody>

            <?php if ($result && $result->num_rows > 0): ?>
                <?php while ($row = $result->fetch_assoc()): ?>
                    <tr>
                        <td><?= (int)$row['id'] ?></td>

                        <?php if ($role === 'SUPER'): ?>
                            <td><?= htmlspecialchars($row['admin_name'] ?? 'N/A') ?></td>
                        <?php endif; ?>

                        <td><?= htmlspecialchars($row['name']) ?></td>
                        <td>₹<?= number_format((float)$row['price'], 2) ?></td>
                        <td>
                            <span class="badge <?= $row['status']=='Active' ? 'bg-success' : 'bg-secondary' ?>">
                                <?= htmlspecialchars($row['status']) ?>
                            </span>
                        </td>
                        <td>
                            <a href="package_edit.php?id=<?= $row['id'] ?>"
                               class="btn btn-sm btn-warning">
                                Edit
                            </a>

                            <a href="package_delete.php?id=<?= $row['id'] ?>"
                               class="btn btn-sm btn-danger"
                               onclick="return confirm('Delete this package? This cannot be undone.');">
                                Delete
                            </a>
                        </td>
                    </tr>
                <?php endwhile; ?>
            <?php else: ?>
                <tr>
                    <td colspan="<?= $role === 'SUPER' ? 6 : 5 ?>" class="text-center">
                        No packages found
                    </td>
                </tr>
            <?php endif; ?>

            </tbody>
        </table>
    </div>

    <div class="mt-3 text-muted">
        <small>
            ⚠️ Packages assigned to customers cannot be deleted.  
            Use <b>Inactive</b> status instead.
        </small>
    </div>

</div>

</body>
</html>
