<?php
$pageTitle = "Collection Reports";

/* ================= HEADER & DB ================= */
include_once "../layout/header.php";
include_once "../config/db.php";

$adminId = $_SESSION['admin_id'];
$role    = $_SESSION['admin_role'] ?? 'ADMIN';

/* ================= DATE FILTER ================= */
$from = $_GET['from'] ?? '';
$to   = $_GET['to'] ?? '';

$where = "1=1";

if ($from && $to) {
    $where .= " AND DATE(payment_date) BETWEEN '$from' AND '$to'";
}

if ($role !== 'SUPER') {
    $where .= " AND admin_id = $adminId";
}

/* ================= TOTAL COLLECTION ================= */
$totalCollection = $conn->query("
    SELECT IFNULL(SUM(amount),0) total
    FROM payments
    WHERE $where
")->fetch_assoc()['total'];

/* ================= MONTH COLLECTION ================= */
$monthlyCollection = $conn->query("
    SELECT IFNULL(SUM(amount),0) total
    FROM payments
    WHERE MONTH(payment_date)=MONTH(CURDATE())
      AND YEAR(payment_date)=YEAR(CURDATE())
      AND $where
")->fetch_assoc()['total'];

/* ================= PENDING ================= */
$pendingAmount = $conn->query("
    SELECT IFNULL(SUM(amount - paid_amount),0) total
    FROM bills
    WHERE status IN ('UNPAID','PARTIAL')
")->fetch_assoc()['total'];

/* ================= DAILY CHART ================= */
$dailyData = [];
$res = $conn->query("
    SELECT DATE(payment_date) d, SUM(amount) t
    FROM payments
    WHERE $where
    GROUP BY DATE(payment_date)
    ORDER BY d DESC
    LIMIT 7
");

while ($r = $res->fetch_assoc()) {
    $dailyData[] = $r;
}
$dailyData = array_reverse($dailyData);

/* ================= MONTHLY CHART ================= */
$monthlyData = [];
$res = $conn->query("
    SELECT DATE_FORMAT(payment_date,'%b %Y') m, SUM(amount) t
    FROM payments
    WHERE $where
    GROUP BY YEAR(payment_date), MONTH(payment_date)
");

while ($r = $res->fetch_assoc()) {
    $monthlyData[] = $r;
}

/* ================= QUERY STRING ================= */
$q = http_build_query(['from'=>$from,'to'=>$to]);
$q = $q ? "?$q" : "";
?>

<!-- ================= FLATPICKR ================= -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/themes/material_blue.css">
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>

<style>
/* ===== FILTER INPUT ===== */
.flatpickr-input {
    padding:10px 12px;
    border-radius:8px;
    border:1px solid #CBD5E1;
    font-size:14px;
    width:160px;
}
.flatpickr-calendar { z-index:99999 !important; }

/* ===== CARDS ===== */
.card-grid {
    display:grid;
    grid-template-columns:repeat(auto-fit,minmax(240px,1fr));
    gap:18px;
    margin:20px 0;
}
.card {
    background:#fff;
    padding:18px;
    border-radius:14px;
    display:flex;
    align-items:center;
    gap:4px;
    box-shadow:0 10px 22px rgba(0,0,0,0.06);
    text-decoration:none !important;
    color:#0F172A;
}
.card:hover { transform:translateY(-4px); }
.card h4 { margin:0;font-size:16px;font-weight:600; }
.card p { margin-top:6px;font-size:18px;font-weight:700; }

.card.green { border-left:6px solid #22C55E; }
.card.blue { border-left:6px solid #3B82F6; }
.card.red { border-left:6px solid #EF4444; }
.card.orange { border-left:6px solid #F59E0B; }

.card span { font-size:34px; }

/* ===== FILTER BAR ===== */
.filter-bar {
    background:#fff;
    padding:16px;
    border-radius:14px;
    margin-bottom:20px;
}

/* ===== CHART ===== */
.card canvas { margin-top:10px; }

/* ===== MOBILE ===== */
@media(max-width:768px){
    .card-grid { grid-template-columns:1fr; }
}



/* ================= MICRO INTERACTIONS ================= */
.card h4,
.action-card {
    transition: color 0.2s ease;
}

.card:hover h4 {
    color: #2563EB;
}

/* ================= MOBILE ================= */
@media (max-width: 768px) {
    .page-header h2 {
        font-size: 20px;
    }

    .card span.material-icons {
        font-size: 32px;
    }

    .section h3 {
        font-size: 16px;
    }
}


/* ================= SECTIONS ================= */
.section {
    margin-top: 32px;
}

.section h3 {
    font-size: 18px;
    font-weight: 600;
    display: flex;
    align-items: center;
    gap: 8px;
    margin-bottom: 14px;
}

/* ================= ACTION GRID ================= */
.action-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
    gap: 14px;
}

/* ================= ACTION CARDS ================= */
.action-card {
    background: #ffffff;
    padding: 16px;
    border-radius: 14px;
    display: flex;
    align-items: center;
    gap: 10px;
    text-decoration: none;
    color: #0F172A;
    box-shadow: 0 8px 18px rgba(0,0,0,0.05);
    transition: all 0.2s ease;
}

.action-card span.material-icons {
    font-size: 26px;
    color: #2563EB;
}

/* Hover */
.action-card:hover {
    transform: translateY(-4px);
    box-shadow: 0 14px 28px rgba(0,0,0,0.10);
}

/* Danger card */
.action-card.danger {
    border-left: 5px solid #EF4444;
}

.action-card.danger span {
    color: #EF4444;
}

/* ================= MICRO INTERACTIONS ================= */
.card h4,
.action-card {
    transition: color 0.2s ease;
}

.card:hover h4 {
    color: #2563EB;
}

/* ================= MOBILE ================= */
@media (max-width: 768px) {
    .page-header h2 {
        font-size: 20px;
    }

    .card span.material-icons {
        font-size: 32px;
    }

    .section h3 {
        font-size: 16px;
    }
}

</style>

<main class="main-content">

<div class="page-header">
    <h2>Collection Reports</h2>
    <p>Live money flow from payments</p>
</div>

<!-- ================= FILTER ================= -->
<form method="get" class="filter-bar">
    <div style="display:flex;gap:16px;flex-wrap:wrap;align-items:end;">
        <div>
            <label>From</label><br>
            <input type="text" id="fromDate" name="from" value="<?= htmlspecialchars($from) ?>">
        </div>
        <div>
            <label>To</label><br>
            <input type="text" id="toDate" name="to" value="<?= htmlspecialchars($to) ?>">
        </div>
        <button class="action-card" style="padding:10px 18px;">
            <span class="material-icons">filter_alt</span> Apply
        </button>
        <?php if($from || $to): ?>
            <a href="collection_reports.php" class="action-card danger" style="padding:10px 18px;">Clear</a>
        <?php endif; ?>
    </div>
</form>

<!-- ================= SUMMARY ================= -->
<div class="card-grid">

    <a href="today_collection_details.php<?= $q ?>" class="card green">
        <span class="material-icons">payments</span>
        <div><h4>Total Collection</h4><p>₹ <?= number_format($totalCollection,2) ?></p></div>
    </a>

    <a href="monthly_collection_details.php<?= $q ?>" class="card blue">
        <span class="material-icons">calendar_month</span>
        <div><h4>This Month</h4><p>₹ <?= number_format($monthlyCollection,2) ?></p></div>
    </a>

    <a href="pending_details.php<?= $q ?>" class="card red">
        <span class="material-icons">warning</span>
        <div><h4>Pending Amount</h4><p>₹ <?= number_format($pendingAmount,2) ?></p></div>
    </a>

    <a href="officer_collection.php<?= $q ?>" class="card orange">
        <span class="material-icons">groups</span>
        <div><h4>Officer Wise</h4><p>View collections</p></div>
    </a>

</div>

    <!-- ================= EXPORT ================= -->
    <div class="section">
        <h3>
            <span class="material-icons">download</span>
            Export & Download
        </h3>

        <div class="action-grid">
            <a href="export_collection.php" class="action-card">
                <span class="material-icons">table_view</span>
                Export Today (Excel)
            </a>

            <a href="export_tccl.php" class="action-card">
                <span class="material-icons">description</span>
                Export VC List (TXT)
            </a>
        </div>

<!-- ================= CHARTS ================= -->
<div class="card-grid">
    <div class="card">
        <h4>Daily Collection</h4>
        <canvas id="dailyChart"></canvas>
    </div>
    <div class="card">
        <h4>Monthly Trend</h4>
        <canvas id="monthlyChart"></canvas>
    </div>
</div>

</main>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
flatpickr("#fromDate",{dateFormat:"Y-m-d"});
flatpickr("#toDate",{dateFormat:"Y-m-d"});

new Chart(dailyChart,{
    type:'bar',
    data:{
        labels:<?= json_encode(array_column($dailyData,'d')) ?>,
        datasets:[{label:'₹ Collection',data:<?= json_encode(array_column($dailyData,'t')) ?>,backgroundColor:'#3B82F6'}]
    }
});

new Chart(monthlyChart,{
    type:'line',
    data:{
        labels:<?= json_encode(array_column($monthlyData,'m')) ?>,
        datasets:[{label:'₹ Collection',data:<?= json_encode(array_column($monthlyData,'t')) ?>,borderColor:'#22C55E',tension:0.4}]
    }
});
</script>

<?php include_once "../layout/footer.php"; ?>
