<?php
include_once __DIR__ . '/../auth_check.php';
include_once __DIR__ . '/../config/db.php';

$adminId = $_SESSION['admin_id'];
$role    = $_SESSION['admin_role'] ?? 'ADMIN';

/* ================= INPUT ================= */
$from = $_GET['from'] ?? '';
$to   = $_GET['to'] ?? '';
$download = isset($_GET['download']);

/* ================= DATE CONDITION ================= */
$whereDate = "";
$params = [];
$types  = "";

if ($from && $to) {
    $whereDate = " AND DATE(p.payment_date) BETWEEN ? AND ?";
    $types .= "ss";
    $params[] = $from;
    $params[] = $to;
}

/* ================= DOWNLOAD EXCEL ================= */
if ($download && $from && $to) {

    header("Content-Type: application/vnd.ms-excel");
    header("Content-Disposition: attachment; filename=collection_{$from}_to_{$to}.xls");

    echo "Time\tCustomer\tAccount No\tVC No\tMobile\tBill ID\tAmount\n";

    if ($role === 'SUPER') {

        $sql = "
            SELECT p.payment_date, p.amount, b.id bill_id,
                   c.`Name`, c.`Account No`, c.`VC Number`, c.`Mobile No`
            FROM payments p
            JOIN bills b ON p.bill_id=b.id
            JOIN customers c ON b.customer_id=c.id
            WHERE 1=1 $whereDate
            ORDER BY p.payment_date
        ";

        $stmt = $conn->prepare($sql);
        $stmt->bind_param($types, ...$params);

    } else {

        $sql = "
            SELECT p.payment_date, p.amount, b.id bill_id,
                   c.`Name`, c.`Account No`, c.`VC Number`, c.`Mobile No`
            FROM payments p
            JOIN bills b ON p.bill_id=b.id
            JOIN customers c ON b.customer_id=c.id
            WHERE c.admin_id=? $whereDate
            ORDER BY p.payment_date
        ";

        $stmt = $conn->prepare($sql);
        $stmt->bind_param("i".$types, $adminId, ...$params);
    }

    $stmt->execute();
    $res = $stmt->get_result();

    while ($r = $res->fetch_assoc()) {
        echo
            date('H:i', strtotime($r['payment_date'])) . "\t" .
            $r['Name'] . "\t" .
            $r['Account No'] . "\t" .
            $r['VC Number'] . "\t" .
            $r['Mobile No'] . "\t" .
            $r['bill_id'] . "\t" .
            number_format($r['amount'], 2) . "\n";
    }
    exit;
}

/* ================= FETCH DATA FOR VIEW ================= */
$data = [];
$total = 0;

if ($from && $to) {

    if ($role === 'SUPER') {

        $sql = "
            SELECT p.payment_date, p.amount,
                   c.`Name`, c.`VC Number`, c.`Mobile No`
            FROM payments p
            JOIN bills b ON p.bill_id=b.id
            JOIN customers c ON b.customer_id=c.id
            WHERE 1=1 $whereDate
            ORDER BY p.payment_date DESC
        ";

        $stmt = $conn->prepare($sql);
        $stmt->bind_param($types, ...$params);

    } else {

        $sql = "
            SELECT p.payment_date, p.amount,
                   c.`Name`, c.`VC Number`, c.`Mobile No`
            FROM payments p
            JOIN bills b ON p.bill_id=b.id
            JOIN customers c ON b.customer_id=c.id
            WHERE c.admin_id=? $whereDate
            ORDER BY p.payment_date DESC
        ";

        $stmt = $conn->prepare($sql);
        $stmt->bind_param("i".$types, $adminId, ...$params);
    }

    $stmt->execute();
    $res = $stmt->get_result();

    while ($r = $res->fetch_assoc()) {
        $data[] = $r;
        $total += $r['amount'];
    }
}
?>

<!DOCTYPE html>
<html>
<head>
<title>Collection Export</title>
<style>
body { font-family: Inter, sans-serif; background:#F4F6FA; margin:0; }
.container { padding:20px; }
.filter-bar {
    background:#fff; padding:16px; border-radius:12px;
    display:flex; gap:12px; align-items:end; flex-wrap:wrap;
}
.filter-bar input { padding:8px; border-radius:8px; border:1px solid #CBD5E1; }
.btn {
    padding:9px 16px; border-radius:8px; border:none;
    background:#2563EB; color:#fff; font-weight:600;
    cursor:pointer; text-decoration:none;
}
.btn.secondary { background:#16A34A; }
.table {
    width:100%; margin-top:20px; background:#fff;
    border-collapse:collapse; border-radius:12px; overflow:hidden;
}
.table th, .table td {
    padding:12px; border-bottom:1px solid #E5E7EB;
}
.table th { background:#F1F5F9; text-align:left; }
tfoot td { font-weight:700; background:#F9FAFB; }
</style>
</head>

<body>
    
    <button class="back-btn" onclick="history.back()">← Go Back</button>
<div class="container">

<h2>Collection Report</h2>

<!-- FILTER -->
<form class="filter-bar" method="get">
    <div>
        <label>From</label><br>
        <input type="date" name="from" value="<?= htmlspecialchars($from) ?>">
    </div>
    <div>
        <label>To</label><br>
        <input type="date" name="to" value="<?= htmlspecialchars($to) ?>">
    </div>
    <button class="btn">Apply</button>

    <?php if ($from && $to): ?>
        <a class="btn secondary"
           href="?from=<?= $from ?>&to=<?= $to ?>&download=1">
           Download Excel
        </a>
    <?php endif; ?>
</form>

<!-- TABLE -->
<?php if ($from && $to): ?>
<table class="table">
<tr>
<th>Date</th><th>Customer</th><th>VC</th><th>Mobile</th><th>Amount</th>
</tr>

<?php if (!$data): ?>
<tr><td colspan="5" align="center">No records found</td></tr>
<?php endif; ?>

<?php foreach ($data as $r): ?>
<tr>
<td><?= $r['payment_date'] ?></td>
<td><?= htmlspecialchars($r['Name']) ?></td>
<td><?= htmlspecialchars($r['VC Number']) ?></td>
<td><?= htmlspecialchars($r['Mobile No']) ?></td>
<td>₹ <?= number_format($r['amount'],2) ?></td>
</tr>
<?php endforeach; ?>

<tfoot>
<tr>
<td colspan="4" align="right">Total</td>
<td>₹ <?= number_format($total,2) ?></td>
</tr>
</tfoot>
</table>
<?php endif; ?>

</div>
</body>
</html>
