<?php
include_once __DIR__ . '/../auth_check.php';
include_once __DIR__ . '/../config/db.php';

/* ================= SESSION ================= */
$adminId = $_SESSION['admin_id'];
$role    = $_SESSION['admin_role'] ?? 'ADMIN';

/* ================= AJAX / DOWNLOAD HANDLER ================= */
if (
    isset($_GET['from'], $_GET['to']) &&
    ($_SERVER['HTTP_X_REQUESTED_WITH'] ?? '') === 'XMLHttpRequest'
) {

    $from = $_GET['from'];
    $to   = $_GET['to'];

    header("Content-Type: text/plain");

    $sql = "
        SELECT DISTINCT c.`VC Number` AS vc
        FROM payments p
        JOIN bills b ON p.bill_id = b.id
        JOIN customers c ON b.customer_id = c.id
        WHERE DATE(p.payment_date) BETWEEN ? AND ?
    ";

    if ($role !== 'SUPER') {
        $sql .= " AND c.admin_id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("ssi", $from, $to, $adminId);
    } else {
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("ss", $from, $to);
    }

    $stmt->execute();
    $res = $stmt->get_result();

    $vcList = [];
    while ($r = $res->fetch_assoc()) {
        if (!empty($r['vc'])) {
            $vcList[] = $r['vc'];
        }
    }

    echo implode(",", $vcList);
    exit;
}

/* ================= DOWNLOAD HANDLER ================= */
if (isset($_GET['from'], $_GET['to'], $_GET['download'])) {

    $from = $_GET['from'];
    $to   = $_GET['to'];

    header("Content-Type: text/plain");
    header("Content-Disposition: attachment; filename=vc_active_{$from}_to_{$to}.txt");

    $sql = "
        SELECT DISTINCT c.`VC Number` AS vc
        FROM payments p
        JOIN bills b ON p.bill_id = b.id
        JOIN customers c ON b.customer_id = c.id
        WHERE DATE(p.payment_date) BETWEEN ? AND ?
    ";

    if ($role !== 'SUPER') {
        $sql .= " AND c.admin_id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("ssi", $from, $to, $adminId);
    } else {
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("ss", $from, $to);
    }

    $stmt->execute();
    $res = $stmt->get_result();

    $vcList = [];
    while ($r = $res->fetch_assoc()) {
        if (!empty($r['vc'])) {
            $vcList[] = $r['vc'];
        }
    }

    echo implode(",", $vcList);
    exit;
}

/* ================= UI PAGE ================= */
$pageTitle = "TCCI Bulk Customer Active";
include_once "../layout/header.php";

$today     = date('Y-m-d');
$yesterday = date('Y-m-d', strtotime('-1 day'));
?>

<style>
.bulk-box {
    background:#fff;
    padding:24px;
    border-radius:14px;
    max-width:620px;
    box-shadow:0 12px 28px rgba(0,0,0,0.08);
}
label { font-weight:600; display:block; margin-top:12px; }
input[type=date] {
    width:100%;
    padding:10px;
    border-radius:8px;
    border:1px solid #CBD5E1;
}
.quick-btn {
    padding:8px 14px;
    border-radius:8px;
    border:none;
    background:#E5E7EB;
    cursor:pointer;
    margin-right:6px;
}
.actions {
    margin-top:18px;
    display:flex;
    gap:10px;
}
.btn {
    padding:12px 18px;
    border-radius:10px;
    border:none;
    cursor:pointer;
    font-weight:600;
}
.btn-green { background:#16A34A; color:#fff; }
.btn-blue  { background:#2563EB; color:#fff; }
.btn-gray  { background:#E5E7EB; }
textarea {
    width:100%;
    height:140px;
    margin-top:14px;
    padding:12px;
    border-radius:10px;
    border:1px solid #CBD5E1;
}
</style>

<main class="main-content">




<div class="page-header">
   
    <p>Export & copy VC numbers by date range</p>
</div>
<button class="back-btn" onclick="history.back()">← Go Back</button>
<div class="bulk-box">

    <button class="quick-btn" onclick="setDate('<?= $today ?>','<?= $today ?>')">Today</button>
    <button class="quick-btn" onclick="setDate('<?= $yesterday ?>','<?= $yesterday ?>')">Yesterday</button>

    <label>From Date</label>
    <input type="date" id="fromDate">

    <label>To Date</label>
    <input type="date" id="toDate">

    <div class="actions">
        <button class="btn btn-green" onclick="loadVC()">Show VC List</button>
        <button class="btn btn-blue" onclick="downloadVC()">Download TXT</button>
        <button class="btn btn-gray" onclick="copyVC()">Copy VC</button>
    </div>

    <textarea id="vcOutput" placeholder="VC list will appear here..."></textarea>

</div>

</main>

<script>
const FILE = "<?= basename($_SERVER['PHP_SELF']) ?>";

function setDate(f,t){
    fromDate.value = f;
    toDate.value = t;
}

function loadVC(){
    const f = fromDate.value;
    const t = toDate.value;

    if(!f || !t){
        alert("Select date range");
        return;
    }

    fetch(`${FILE}?from=${f}&to=${t}`, {
        headers: { 'X-Requested-With': 'XMLHttpRequest' }
    })
    .then(r => r.text())
    .then(txt => vcOutput.value = txt.trim());
}

function downloadVC(){
    const f = fromDate.value;
    const t = toDate.value;

    if(!f || !t){
        alert("Select date range");
        return;
    }

    window.open(`${FILE}?from=${f}&to=${t}&download=1`);
}

function copyVC(){
    if(!vcOutput.value){
        alert("Nothing to copy");
        return;
    }
    navigator.clipboard.writeText(vcOutput.value);
    alert("VC list copied");
}
</script>

<?php include_once "../layout/footer.php"; ?>
