<?php
include_once __DIR__ . '/../auth_check.php';
include_once __DIR__ . '/../config/db.php';

$adminId = $_SESSION['admin_id'];
$role    = $_SESSION['admin_role'] ?? 'ADMIN';

/* ================= AJAX / DOWNLOAD HANDLER ================= */
if (isset($_GET['from'], $_GET['to'])) {

    $from = $_GET['from'];
    $to   = $_GET['to'];

    header("Content-Type: text/plain");

    $sql = "
        SELECT DISTINCT c.`VC Number` AS vc
        FROM payments p
        JOIN bills b ON p.bill_id = b.id
        JOIN customers c ON b.customer_id = c.id
        WHERE DATE(p.payment_date) BETWEEN ? AND ?
    ";

    if ($role !== 'SUPER') {
        $sql .= " AND c.admin_id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("ssi", $from, $to, $adminId);
    } else {
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("ss", $from, $to);
    }

    $stmt->execute();
    $res = $stmt->get_result();

    $vcList = [];
    while ($r = $res->fetch_assoc()) {
        if (!empty($r['vc'])) {
            $vcList[] = $r['vc'];
        }
    }

    echo implode(",", $vcList);
    exit;
}

/* ================= UI PAGE ================= */
$pageTitle = "TCCl Bulk Customer Active";
include_once "../layout/header.php";
include_once "../layout/sidebar.php";

$today     = date('Y-m-d');
$yesterday = date('Y-m-d', strtotime('-1 day'));
?>

<style>
.bulk-box {
    background:#fff;
    padding:24px;
    border-radius:14px;
    max-width:560px;
    box-shadow:0 12px 28px rgba(0,0,0,0.08);
}
.bulk-box h3 { margin-top:0; }
label { font-weight:600; display:block; margin-top:12px; }
input[type=date] {
    width:100%;
    padding:10px;
    border-radius:8px;
    border:1px solid #CBD5E1;
}
.quick-btn {
    padding:8px 14px;
    border-radius:8px;
    border:none;
    background:#E5E7EB;
    cursor:pointer;
    margin-right:6px;
}
.quick-btn:hover { background:#D1D5DB; }
.actions { margin-top:18px; display:flex; gap:10px; flex-wrap:wrap; }
.btn {
    padding:12px 18px;
    border-radius:10px;
    border:none;
    cursor:pointer;
    font-weight:600;
}
.btn-green { background:#16A34A; color:#fff; }
.btn-blue  { background:#2563EB; color:#fff; }
.btn-gray  { background:#E5E7EB; }
textarea {
    width:100%;
    height:120px;
    margin-top:14px;
    padding:12px;
    border-radius:10px;
    border:1px solid #CBD5E1;
    resize:none;
}
</style>

<main class="main-content">

<div class="page-header">
    <h2>TCCl Bulk Customer Active</h2>
    <p>Export & copy VC numbers by date range</p>
</div>

<div class="bulk-box">

    <div>
        <button class="quick-btn" onclick="setDate('<?= $today ?>','<?= $today ?>')">Today</button>
        <button class="quick-btn" onclick="setDate('<?= $yesterday ?>','<?= $yesterday ?>')">Yesterday</button>
    </div>

    <label>From Date</label>
    <input type="date" id="fromDate">

    <label>To Date</label>
    <input type="date" id="toDate">

    <div class="actions">
        <button class="btn btn-green" onclick="loadVC()">Show VC List</button>
        <button class="btn btn-blue" onclick="downloadVC()">Download TXT</button>
        <a href="reports_dashboard.php" class="btn btn-gray">Back</a>
    </div>

    <textarea id="vcOutput" placeholder="VC list will appear here..."></textarea>

    <button class="btn btn-blue" onclick="copyVC()">Copy VC List</button>

</div>

</main>

<script>
function setDate(f,t){
    fromDate.value=f;
    toDate.value=t;
}

function loadVC(){
    const f=fromDate.value, t=toDate.value;
    if(!f||!t){ alert("Select dates"); return; }

    fetch(`export_vc_bulk.php?from=${f}&to=${t}`)
        .then(r=>r.text())
        .then(txt=>vcOutput.value=txt.trim());
}

function downloadVC(){
    const f=fromDate.value, t=toDate.value;
    if(!f||!t){ alert("Select dates"); return; }
    window.open(`export_vc_bulk.php?from=${f}&to=${t}`,'_blank');
}

function copyVC(){
    if(!vcOutput.value){ alert("Nothing to copy"); return; }
    vcOutput.select();
    navigator.clipboard.writeText(vcOutput.value);
    alert("VC list copied");
}
</script>

<?php include_once "../layout/footer.php"; ?>
