<?php
$pageTitle = "Monthly Collection Details";
include_once "../layout/header.php";
include_once "../config/db.php";

$adminId = $_SESSION['admin_id'];
$role    = $_SESSION['admin_role'] ?? 'ADMIN';

$sql = "
SELECT 
    p.payment_date,
    p.amount,
    c.Name,
    c.`VC Number`,
    c.`Mobile No`,
    o.name AS officer,
    ad.username AS admin_name
FROM payments p
JOIN bills b ON p.bill_id = b.id
JOIN customers c ON b.customer_id = c.id
LEFT JOIN officers o ON p.officer_id = o.id
LEFT JOIN admins ad ON c.admin_id = ad.id
WHERE MONTH(p.payment_date)=MONTH(CURDATE())
  AND YEAR(p.payment_date)=YEAR(CURDATE())
";

if ($role !== 'SUPER') {
    $sql .= " AND p.admin_id = $adminId";
}

$sql .= " ORDER BY p.payment_date DESC";
$res = $conn->query($sql);
$grandTotal = 0;
?>

<style>
/* ================= TABLE ================= */
.table {
    width: 100%;
    border-collapse: collapse;
    background: #ffffff;
    margin-top: 16px;
    border-radius: 12px;
    overflow: hidden;
    box-shadow: 0 8px 20px rgba(0,0,0,0.05);
}
.table th {
    background: #F1F5F9;
    color: #0F172A;
    font-weight: 600;
    padding: 12px;
    text-align: left;
    font-size: 14px;
}
.table td {
    padding: 12px;
    border-top: 1px solid #E5E7EB;
    font-size: 14px;
}
.table tr:hover {
    background: #F8FAFC;
}
.table tfoot td {
    font-weight: 700;
    background: #F9FAFB;
}

/* ================= BADGES ================= */
.badge-admin {
    color: #059669;
    font-weight: 600;
}
.badge-officer {
    color: #2563EB;
    font-weight: 600;
}

/* ================= BACK BUTTON ================= */
.back-btn {
    display: inline-flex;
    align-items: center;
    gap: 6px;
    background: #ffffff;
    border: 1px solid #E5E7EB;
    padding: 8px 14px;
    border-radius: 10px;
    font-size: 14px;
    font-weight: 600;
    color: #0F172A;
    cursor: pointer;
    box-shadow: 0 4px 10px rgba(0,0,0,0.05);
    transition: all 0.2s ease;
    margin-bottom: 14px;
}
.back-btn:hover {
    background: #F8FAFC;
    transform: translateX(-2px);
}
</style>

<main class="main-content">

<!-- ================= BACK BUTTON ================= -->
<button class="back-btn" onclick="history.back()">
    ← Go Back
</button>

<h2>This Month Collection</h2>

<table class="table">
<tr>
    <th>Date</th>
    <th>Customer</th>
    <th>VC</th>
    <th>Mobile</th>
    <th>Collected By</th>
    <th>Amount</th>
</tr>

<?php while($r=$res->fetch_assoc()):
    $grandTotal += $r['amount']; ?>
<tr>
    <td><?= $r['payment_date'] ?></td>
    <td><?= htmlspecialchars($r['Name']) ?></td>
    <td><?= htmlspecialchars($r['VC Number']) ?></td>
    <td><?= htmlspecialchars($r['Mobile No']) ?></td>
    <td>
        <?php if ($r['officer']): ?>
            <span class="badge-officer">👮 <?= htmlspecialchars($r['officer']) ?></span>
        <?php else: ?>
            <span class="badge-admin">🧑‍💼 <?= htmlspecialchars($r['admin_name']) ?></span>
        <?php endif; ?>
    </td>
    <td>₹ <?= number_format($r['amount'],2) ?></td>
</tr>
<?php endwhile; ?>

<tfoot>
<tr>
    <td colspan="5" align="right">Grand Total</td>
    <td>₹ <?= number_format($grandTotal,2) ?></td>
</tr>
</tfoot>
</table>

</main>

<?php include_once "../layout/footer.php"; ?>
