<?php
$pageTitle = "Officer Wise Collection";
include_once "../layout/header.php";
include_once "../config/db.php";

$adminId   = $_SESSION['admin_id'];
$role      = $_SESSION['admin_role'] ?? 'ADMIN';
$officerId = intval($_GET['officer_id'] ?? 0);
?>

<style>
.table {
    width: 100%;
    border-collapse: collapse;
    background: #ffffff;
    margin-top: 16px;
    border-radius: 12px;
    overflow: hidden;
    box-shadow: 0 8px 20px rgba(0,0,0,0.05);
}
.table th {
    background: #F1F5F9;
    color: #0F172A;
    font-weight: 600;
    padding: 12px;
    font-size: 14px;
    text-align: left;
}
.table td {
    padding: 12px;
    border-top: 1px solid #E5E7EB;
    font-size: 14px;
}
.table tr:hover { background:#F8FAFC; }
.table tfoot td {
    font-weight: 700;
    background:#F9FAFB;
}

.back-btn {
    display:inline-flex;
    align-items:center;
    gap:6px;
    background:#fff;
    border:1px solid #E5E7EB;
    padding:8px 14px;
    border-radius:10px;
    font-size:14px;
    font-weight:600;
    cursor:pointer;
    box-shadow:0 4px 10px rgba(0,0,0,0.05);
}
.back-btn:hover { background:#F8FAFC; }

a.officer-link {
    text-decoration:none;
    font-weight:600;
    color:#2563EB;
}
a.officer-link:hover { text-decoration:underline; }
</style>

<main class="main-content">
    <button class="back-btn" onclick="window.location.href='collection_reports.php'">
    ← Go Back
</button>

<?php
/* ======================================================
   OFFICER DETAILS VIEW
====================================================== */
if ($officerId > 0):

    $sql = "
    SELECT 
        p.payment_date,
        p.amount,
        c.Name,
        c.`VC Number`,
        c.`Mobile No`,
        b.bill_month,
        b.bill_year
    FROM payments p
    JOIN bills b ON p.bill_id = b.id
    JOIN customers c ON b.customer_id = c.id
    WHERE p.officer_id = $officerId
    ";

    if ($role !== 'SUPER') {
        $sql .= " AND p.admin_id = $adminId";
    }

    $sql .= " ORDER BY p.payment_date DESC";

    $res = $conn->query($sql);
    $grandTotal = 0;
    
    
?>



<h2 style="margin-top:14px;">Officer Collection Details</h2>

<table class="table">
<tr>
    <th>Date</th>
    <th>Customer</th>
    <th>VC</th>
    <th>Mobile</th>
    <th>Bill</th>
    <th>Amount</th>
</tr>

<?php while($r=$res->fetch_assoc()):
    $grandTotal += $r['amount']; ?>
<tr>
    <td><?= $r['payment_date'] ?></td>
    <td><?= htmlspecialchars($r['Name']) ?></td>
    <td><?= htmlspecialchars($r['VC Number']) ?></td>
    <td><?= htmlspecialchars($r['Mobile No']) ?></td>
    <td><?= $r['bill_month'] ?>/<?= $r['bill_year'] ?></td>
    <td>₹ <?= number_format($r['amount'],2) ?></td>
</tr>
<?php endwhile; ?>

<tfoot>
<tr>
    <td colspan="5" align="right">Total</td>
    <td>₹ <?= number_format($grandTotal,2) ?></td>
</tr>
</tfoot>
</table>

<?php
/* ======================================================
   OFFICER SUMMARY VIEW
====================================================== */
else:

$sql = "
SELECT 
    o.id AS officer_id,
    o.name,
    IFNULL(SUM(p.amount),0) AS total
FROM payments p
JOIN officers o ON p.officer_id = o.id
WHERE p.officer_id IS NOT NULL
";

if ($role !== 'SUPER') {
    $sql .= " AND p.admin_id = $adminId";
}

$sql .= " GROUP BY o.id, o.name ORDER BY o.name";

$res = $conn->query($sql);
?>

<div class="page-header">
    <h2>Officer Wise Collection</h2>
    <p>Click an officer to view payment details</p>
</div>

<table class="table">
<tr>
    <th>Officer Name</th>
    <th>Total Collection</th>
</tr>

<?php while($r=$res->fetch_assoc()): ?>
<tr>
    <td>
        <a class="officer-link"
           href="officer_collection.php?officer_id=<?= $r['officer_id'] ?>">
           <?= htmlspecialchars($r['name']) ?>
        </a>
    </td>
    <td>₹ <?= number_format($r['total'],2) ?></td>
</tr>
<?php endwhile; ?>
</table>

<?php endif; ?>

</main>

<?php include_once "../layout/footer.php"; ?>
