<?php
include_once __DIR__ . '/../auth_check.php';
include_once __DIR__ . '/../config/db.php';

$adminId = $_SESSION['admin_id'];
$role    = $_SESSION['admin_role'];

/* ================= DATE FILTER ================= */
$fromDate = $_GET['from'] ?? date('Y-m-01');
$toDate   = $_GET['to']   ?? date('Y-m-d');

/* ================= SUMMARY QUERY ================= */
if ($role === 'SUPER') {

    $summarySql = "
        SELECT
            DATE(p.payment_date) AS pay_date,
            COUNT(p.id)          AS total_payments,
            SUM(p.amount)        AS total_amount
        FROM payments p
        WHERE DATE(p.payment_date) BETWEEN ? AND ?
        GROUP BY DATE(p.payment_date)
        ORDER BY pay_date DESC
    ";
    $summaryStmt = $conn->prepare($summarySql);
    $summaryStmt->bind_param("ss", $fromDate, $toDate);

} else {

    $summarySql = "
        SELECT
            DATE(p.payment_date) AS pay_date,
            COUNT(p.id)          AS total_payments,
            SUM(p.amount)        AS total_amount
        FROM payments p
        JOIN bills b ON p.bill_id = b.id
        JOIN customers c ON b.customer_id = c.id
        WHERE c.admin_id = ?
          AND DATE(p.payment_date) BETWEEN ? AND ?
        GROUP BY DATE(p.payment_date)
        ORDER BY pay_date DESC
    ";
    $summaryStmt = $conn->prepare($summarySql);
    $summaryStmt->bind_param("iss", $adminId, $fromDate, $toDate);
}

$summaryStmt->execute();
$summaryResult = $summaryStmt->get_result();

/* ================= DETAIL QUERY ================= */
if ($role === 'SUPER') {

    $detailSql = "
        SELECT
            p.payment_date,
            p.amount,
            b.id AS bill_id,
            c.`Name`        AS customer_name,
            c.`Account No`  AS account_no,
            c.`VC Number`   AS vc_number,
            c.`Mobile No`   AS mobile
        FROM payments p
        JOIN bills b ON p.bill_id = b.id
        JOIN customers c ON b.customer_id = c.id
        WHERE DATE(p.payment_date) BETWEEN ? AND ?
        ORDER BY p.payment_date DESC
    ";
    $detailStmt = $conn->prepare($detailSql);
    $detailStmt->bind_param("ss", $fromDate, $toDate);

} else {

    $detailSql = "
        SELECT
            p.payment_date,
            p.amount,
            b.id AS bill_id,
            c.`Name`        AS customer_name,
            c.`Account No`  AS account_no,
            c.`VC Number`   AS vc_number,
            c.`Mobile No`   AS mobile
        FROM payments p
        JOIN bills b ON p.bill_id = b.id
        JOIN customers c ON b.customer_id = c.id
        WHERE c.admin_id = ?
          AND DATE(p.payment_date) BETWEEN ? AND ?
        ORDER BY p.payment_date DESC
    ";
    $detailStmt = $conn->prepare($detailSql);
    $detailStmt->bind_param("iss", $adminId, $fromDate, $toDate);
}

$detailStmt->execute();
$detailResult = $detailStmt->get_result();
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Day Wise Collection Report</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>

<div class="container mt-4">

    <h3 class="mb-3">Day Wise Collection Report</h3>

    <!-- FILTER -->
    <form class="row g-2 mb-4">
        <div class="col-md-3">
            <label>From</label>
            <input type="date" name="from" class="form-control" value="<?= $fromDate ?>">
        </div>
        <div class="col-md-3">
            <label>To</label>
            <input type="date" name="to" class="form-control" value="<?= $toDate ?>">
        </div>
        <div class="col-md-3 align-self-end">
            <button class="btn btn-primary">Filter</button>
        </div>
    </form>

    <!-- ================= SUMMARY TABLE ================= -->
    <h5 class="mb-2">Summary</h5>
    <div class="table-responsive mb-5">
        <table class="table table-bordered table-striped">
            <thead class="table-dark">
            <tr>
                <th>#</th>
                <th>Date</th>
                <th>Total Payments</th>
                <th>Total Amount</th>
            </tr>
            </thead>
            <tbody>
            <?php $i=1; while ($row = $summaryResult->fetch_assoc()): ?>
                <tr>
                    <td><?= $i++ ?></td>
                    <td><?= date('d M Y', strtotime($row['pay_date'])) ?></td>
                    <td><?= $row['total_payments'] ?></td>
                    <td class="fw-bold text-success">
                        ₹<?= number_format($row['total_amount'],2) ?>
                    </td>
                </tr>
            <?php endwhile; ?>
            </tbody>
        </table>
    </div>

    <!-- ================= CUSTOMER DETAIL TABLE ================= -->
    <h5 class="mb-2">Customer Payment Details</h5>
    <div class="table-responsive">
        <table class="table table-bordered table-hover align-middle">
            <thead class="table-secondary">
            <tr>
                <th>#</th>
                <th>Date</th>
                <th>Customer</th>
                <th>Account No</th>
                <th>VC No</th>
                <th>Mobile</th>
                <th>Bill ID</th>
                <th>Paid Amount</th>
            </tr>
            </thead>
            <tbody>
            <?php $i=1; while ($row = $detailResult->fetch_assoc()): ?>
                <tr>
                    <td><?= $i++ ?></td>
                    <td><?= date('d M Y H:i', strtotime($row['payment_date'])) ?></td>
                    <td><?= htmlspecialchars($row['customer_name']) ?></td>
                    <td><?= htmlspecialchars($row['account_no']) ?></td>
                    <td><?= htmlspecialchars($row['vc_number']) ?></td>
                    <td><?= htmlspecialchars($row['mobile']) ?></td>
                    <td>#<?= $row['bill_id'] ?></td>
                    <td class="fw-bold text-success">
                        ₹<?= number_format($row['amount'],2) ?>
                    </td>
                </tr>
            <?php endwhile; ?>
            </tbody>
        </table>
    </div>

    <a href="../dashboard.php" class="btn btn-secondary mt-3">Back</a>

</div>

</body>
</html>
