<?php
$pageTitle = "Pending Bills";
include_once "../layout/header.php";

include_once "../config/db.php";

$adminId = $_SESSION['admin_id'];
$role    = $_SESSION['admin_role'];

$sql = "
SELECT 
    c.Name,
    c.`VC Number`,
    c.`Mobile No`,
    b.amount,
    b.paid_amount,
    (b.amount - b.paid_amount) AS pending,
    DATEDIFF(CURDATE(), b.bill_date) AS pending_days
FROM bills b
JOIN customers c ON b.customer_id = c.id
WHERE b.status IN ('UNPAID','PARTIAL')
";

if ($role !== 'SUPER') {
    $sql .= " AND c.admin_id = $adminId";
}

$res = $conn->query($sql);
?>
<style>
.table {
    width: 100%;
    border-collapse: collapse;
    background: #ffffff;
    margin-top: 16px;
    border-radius: 12px;
    overflow: hidden;
    box-shadow: 0 8px 20px rgba(0,0,0,0.05);
}
.table th {
    background: #F1F5F9;
    color: #0F172A;
    font-weight: 600;
    padding: 12px;
    text-align: left;
    font-size: 14px;
}
.table td {
    padding: 12px;
    border-top: 1px solid #E5E7EB;
    font-size: 14px;
}
.table tr:hover {
    background: #F8FAFC;
}
.table tfoot td {
    font-weight: 700;
    background: #F9FAFB;
}
.badge-admin {
    color: #059669;
    font-weight: 600;
}
.badge-officer {
    color: #2563EB;
    font-weight: 600;
}

/* ================= BACK BUTTON ================= */
.back-btn {
    display: inline-flex;
    align-items: center;
    gap: 6px;
    background: #ffffff;
    border: 1px solid #E5E7EB;
    padding: 8px 14px;
    border-radius: 10px;
    font-size: 14px;
    font-weight: 600;
    color: #0F172A;
    cursor: pointer;
    box-shadow: 0 4px 10px rgba(0,0,0,0.05);
    transition: all 0.2s ease;
    margin-bottom: 14px;
}
.back-btn:hover {
    background: #F8FAFC;
    transform: translateX(-2px);
}
</style>

<main class="main-content">
        
    <!-- ================= BACK BUTTON ================= -->
<button class="back-btn" onclick="history.back()">
    ← Go Back
</button>
    
<h2>Pending Customers</h2>

<table class="table">
<tr>
<th>Customer</th><th>VC</th><th>Mobile</th><th>Bill</th><th>Paid</th><th>Pending</th><th>Days</th>
</tr>

<?php while($r=$res->fetch_assoc()): ?>
<tr>
<td><?= $r['Name'] ?></td>
<td><?= $r['VC Number'] ?></td>
<td><?= $r['Mobile No'] ?></td>
<td>₹ <?= $r['amount'] ?></td>
<td>₹ <?= $r['paid_amount'] ?></td>
<td style="color:red;">₹ <?= $r['pending'] ?></td>
<td style="color:<?= $r['pending_days'] > 30 ? 'red' : '#0F172A' ?>">
<?= $r['pending_days'] ?> days
</td>
</tr>
<?php endwhile; ?>
</table>
</main>

<?php include_once "../layout/footer.php"; ?>
