<?php
$pageTitle = "Reports";
/* ================= HEADER ================= */
include_once "../layout/header.php";

?>
<style>
    
    
    /* ================= PAGE HEADER ================= */
.page-header {
    margin-bottom: 24px;
}

.page-header h2 {
    font-size: 22px;
    font-weight: 700;
    margin-bottom: 4px;
}

.page-header p {
    color: #64748B;
    font-size: 14px;
}

/* ================= CARD GRID ================= */
.card-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
    gap: 18px;
    margin-bottom: 28px;
}

/* ================= SUMMARY CARDS ================= */
.card {
    background: #ffffff;
    border-radius: 16px;
    padding: 18px;
    display: flex;
    gap: 14px;
    align-items: center;
    text-decoration: none;
    color: #0F172A;
    box-shadow: 0 10px 24px rgba(0,0,0,0.06);
    transition: all 0.25s ease;
    position: relative;
    overflow: hidden;
}

.card span.material-icons {
    font-size: 38px;
}

/* Hover animation */
.card:hover {
    transform: translateY(-6px);
    box-shadow: 0 18px 36px rgba(0,0,0,0.12);
}

/* Gradient glow on hover */
.card::after {
    content: "";
    position: absolute;
    inset: 0;
    background: linear-gradient(120deg, transparent, rgba(255,255,255,0.35), transparent);
    opacity: 0;
    transition: opacity 0.3s;
}

.card:hover::after {
    opacity: 1;
}

/* ================= CARD COLORS ================= */
.card.green { border-left: 6px solid #22C55E; }
.card.blue  { border-left: 6px solid #3B82F6; }
.card.red   { border-left: 6px solid #EF4444; }
.card.orange{ border-left: 6px solid #F59E0B; }

.card.green span  { color: #22C55E; }
.card.blue span   { color: #3B82F6; }
.card.red span    { color: #EF4444; }
.card.orange span { color: #F59E0B; }

/* ================= SECTIONS ================= */
.section {
    margin-top: 32px;
}

.section h3 {
    font-size: 18px;
    font-weight: 600;
    display: flex;
    align-items: center;
    gap: 8px;
    margin-bottom: 14px;
}

/* ================= ACTION GRID ================= */
.action-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
    gap: 14px;
}

/* ================= ACTION CARDS ================= */
.action-card {
    background: #ffffff;
    padding: 16px;
    border-radius: 14px;
    display: flex;
    align-items: center;
    gap: 10px;
    text-decoration: none;
    color: #0F172A;
    box-shadow: 0 8px 18px rgba(0,0,0,0.05);
    transition: all 0.2s ease;
}

.action-card span.material-icons {
    font-size: 26px;
    color: #2563EB;
}

/* Hover */
.action-card:hover {
    transform: translateY(-4px);
    box-shadow: 0 14px 28px rgba(0,0,0,0.10);
}

/* Danger card */
.action-card.danger {
    border-left: 5px solid #EF4444;
}

.action-card.danger span {
    color: #EF4444;
}

/* ================= MICRO INTERACTIONS ================= */
.card h4,
.action-card {
    transition: color 0.2s ease;
}

.card:hover h4 {
    color: #2563EB;
}

/* ================= MOBILE ================= */
@media (max-width: 768px) {
    .page-header h2 {
        font-size: 20px;
    }

    .card span.material-icons {
        font-size: 32px;
    }

    .section h3 {
        font-size: 16px;
    }
}

</style>
<main class="main-content">

    <div class="page-header">
      
        <p>Quick insights and detailed billing reports</p>
    </div>

    <!-- ================= QUICK INSIGHTS ================= -->
    <div class="card-grid">

        <a href="today_collection_details.php" class="card green">
            <span class="material-icons">payments</span>
            <div>
                <h4>Today Collection</h4>
                <p>Tap to view today�s payments</p>
            </div>
        </a>

        <a href="monthly_collection_details.php" class="card blue">
            <span class="material-icons">calendar_month</span>
            <div>
                <h4>Monthly Collection</h4>
                <p>Tap to view this month</p>
            </div>
        </a>

        <a href="pending_details.php" class="card red">
            <span class="material-icons">warning</span>
            <div>
                <h4>Pending Bills</h4>
                <p>Tap to view unpaid customers</p>
            </div>
        </a>

        <a href="officer_collection.php" class="card orange">
            <span class="material-icons">groups</span>
            <div>
                <h4>Officer Performance</h4>
                <p>Tap to view officer collections</p>
            </div>
        </a>

    </div>

    <!-- ================= DETAILED REPORTS ================= -->
    <div class="section">
        <h3>
            <span class="material-icons">bar_chart</span>
            Detailed Collection Reports
        </h3>

        <div class="action-grid">
            <a href="day_wise_report.php" class="action-card">
                <span class="material-icons">date_range</span>
                Day Wise Collection
            </a>

            <a href="monthly_billing_report.php" class="action-card">
                <span class="material-icons">stacked_bar_chart</span>
                Month Wise Collection
            </a>

            <a href="officer_wise_collection.php" class="action-card">
                <span class="material-icons">badge</span>
                Officer Wise Summary
            </a>
        </div>
    </div>

    <!-- ================= PENDING & DUE ================= -->
    <div class="section">
        <h3>
            <span class="material-icons">report_problem</span>
            Pending & Due Reports
        </h3>

        <div class="action-grid">
            <a href="pending_bills_report.php" class="action-card danger">
                <span class="material-icons">warning</span>
                Pending Bills Report
            </a>
        </div>
    </div>

    <!-- ================= EXPORT ================= -->
    <div class="section">
        <h3>
            <span class="material-icons">download</span>
            Export & Download
        </h3>

        <div class="action-grid">
            <a href="export_collection.php" class="action-card">
                <span class="material-icons">table_view</span>
                Export Today (Excel)
            </a>

            <a href="export_vc_bulk.php" class="action-card">
                <span class="material-icons">description</span>
                Export VC List (TXT)
            </a>
        </div>
    </div>

</main>

<?php include_once "../layout/footer.php"; ?>
