<?php
$pageTitle = "Today Collection Details";
include_once "../layout/header.php";
include_once "../config/db.php";

$adminId = $_SESSION['admin_id'];
$role    = $_SESSION['admin_role'] ?? 'ADMIN';

/* ================= DATE FILTER ================= */
$from = $_GET['from'] ?? '';
$to   = $_GET['to'] ?? '';

$whereDate = "";

/* If date range passed */
if ($from && $to) {
    $whereDate = "AND DATE(p.payment_date) BETWEEN '$from' AND '$to'";
}
/* If only one date passed */
elseif ($from) {
    $whereDate = "AND DATE(p.payment_date) = '$from'";
}
/* Default = TODAY */
else {
    $whereDate = "AND DATE(p.payment_date) = CURDATE()";
}

/* ================= QUERY ================= */
$sql = "
SELECT 
    p.payment_date,
    p.amount,
    c.Name,
    c.`VC Number`,
    c.`Mobile No`,
    o.name AS officer,
    ad.username AS admin_name
FROM payments p
JOIN bills b ON p.bill_id = b.id
JOIN customers c ON b.customer_id = c.id
LEFT JOIN officers o ON p.officer_id = o.id
LEFT JOIN admins ad ON c.admin_id = ad.id
WHERE 1=1
$whereDate
";

if ($role !== 'SUPER') {
    $sql .= " AND p.admin_id = $adminId";
}

$sql .= " ORDER BY p.payment_date DESC";

$res = $conn->query($sql);
$grandTotal = 0;
?>
<style>
.table {
    width: 100%;
    border-collapse: collapse;
    background: #ffffff;
    margin-top: 16px;
    border-radius: 12px;
    overflow: hidden;
    box-shadow: 0 8px 20px rgba(0,0,0,0.05);
}
.table th {
    background: #F1F5F9;
    color: #0F172A;
    font-weight: 600;
    padding: 12px;
    font-size: 14px;
}
.table td {
    padding: 12px;
    border-top: 1px solid #E5E7EB;
    font-size: 14px;
}
.table tr:hover { background:#F8FAFC; }
.table tfoot td {
    font-weight: 700;
    background:#F9FAFB;
}

.back-btn {
    display:inline-flex;
    align-items:center;
    gap:6px;
    background:#fff;
    border:1px solid #E5E7EB;
    padding:8px 14px;
    border-radius:10px;
    font-size:14px;
    font-weight:600;
    cursor:pointer;
    margin-bottom:14px;
}
.back-btn:hover {
    background:#F8FAFC;
}
</style>

<main class="main-content">

<button class="back-btn" onclick="history.back()">← Go Back</button>

<h2>
    <?php if ($from || $to): ?>
        Collection from <?= htmlspecialchars($from) ?> <?= $to ? "to ".htmlspecialchars($to) : "" ?>
    <?php else: ?>
        Today Collection
    <?php endif; ?>
</h2>

<table class="table">
<tr>
    <th>Date</th>
    <th>Customer</th>
    <th>VC</th>
    <th>Mobile</th>
    <th>Collected By</th>
    <th>Amount</th>
</tr>

<?php if ($res->num_rows == 0): ?>
<tr>
    <td colspan="6" style="text-align:center;">No records found</td>
</tr>
<?php endif; ?>

<?php while($r = $res->fetch_assoc()):
    $grandTotal += $r['amount']; ?>
<tr>
    <td><?= $r['payment_date'] ?></td>
    <td><?= htmlspecialchars($r['Name']) ?></td>
    <td><?= htmlspecialchars($r['VC Number']) ?></td>
    <td><?= htmlspecialchars($r['Mobile No']) ?></td>
    <td><?= htmlspecialchars($r['officer'] ?: $r['admin_name']) ?></td>
    <td>₹ <?= number_format($r['amount'],2) ?></td>
</tr>
<?php endwhile; ?>

<tfoot>
<tr>
    <td colspan="5" align="right">Grand Total</td>
    <td>₹ <?= number_format($grandTotal,2) ?></td>
</tr>
</tfoot>
</table>

</main>

<?php include_once "../layout/footer.php"; ?>
