<?php
header("Content-Type: application/json");

include_once "../admin/config/db.php";
include_once "jwt.php";

/*
|--------------------------------------------------------------------------
| JWT AUTH
|--------------------------------------------------------------------------
*/
$headers = getallheaders();
$auth = $headers['Authorization'] ?? '';

if (!$auth || !preg_match('/Bearer\s(\S+)/', $auth, $matches)) {
    http_response_code(401);
    echo json_encode(["success"=>false,"message"=>"Unauthorized"]);
    exit;
}

$user = verify_jwt($matches[1]);
if (!$user || empty($user['role'])) {
    http_response_code(401);
    echo json_encode(["success"=>false,"message"=>"Invalid token"]);
    exit;
}

$role    = $user['role'];
$adminId = $user['admin_id'] ?? null;

/*
|--------------------------------------------------------------------------
| FETCH AREAS (ADMIN BASED)
|--------------------------------------------------------------------------
*/
if ($role === 'SUPER') {

    // SUPER admin → all areas
    $sql = "
        SELECT DISTINCT TRIM(`Address`) AS area
        FROM customers
        WHERE `Address` IS NOT NULL AND `Address` != ''
        ORDER BY area ASC
    ";
    $stmt = $conn->prepare($sql);

} else {

    if (!$adminId) {
        echo json_encode(["success"=>false,"message"=>"Admin missing"]);
        exit;
    }

    $sql = "
        SELECT DISTINCT TRIM(`Address`) AS area
        FROM customers
        WHERE admin_id = ?
          AND `Address` IS NOT NULL
          AND `Address` != ''
        ORDER BY area ASC
    ";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $adminId);
}

$stmt->execute();
$res = $stmt->get_result();

$areas = [];
while ($row = $res->fetch_assoc()) {
    $areas[] = $row['area'];
}
$stmt->close();

echo json_encode([
    "success" => true,
    "areas" => $areas
], JSON_UNESCAPED_UNICODE);
