<?php
header("Content-Type: application/json");

include_once "../admin/config/db.php";
include_once "jwt.php";

/*
|--------------------------------------------------------------------------
| JWT AUTH
|--------------------------------------------------------------------------
*/
$headers = getallheaders();
$auth = $headers['Authorization'] ?? '';

if (!$auth || !preg_match('/Bearer\s(\S+)/', $auth, $matches)) {
    http_response_code(401);
    echo json_encode([
        "success" => false,
        "message" => "Unauthorized"
    ]);
    exit;
}

$token = $matches[1];
$user  = verify_jwt($token);

if (!$user || empty($user['role'])) {
    http_response_code(401);
    echo json_encode([
        "success" => false,
        "message" => "Invalid or expired token"
    ]);
    exit;
}

/*
|--------------------------------------------------------------------------
| INPUT
|--------------------------------------------------------------------------
*/
$vc = trim($_GET['vc'] ?? '');
if ($vc === '') {
    echo json_encode([
        "success" => false,
        "message" => "VC number required"
    ]);
    exit;
}

/*
|--------------------------------------------------------------------------
| ROLE BASED QUERY
|--------------------------------------------------------------------------
*/
$role    = $user['role'];
$adminId = $user['admin_id'] ?? null;

if ($role === 'SUPER') {

    $sql = "
        SELECT 
            b.id AS bill_id,
            b.amount AS bill_amount,
            b.paid_amount,
            b.status,
            b.bill_month,
            b.bill_year,
            c.`Name` AS customer_name,
            c.`Account No` AS account_no,
            c.`VC Number` AS vc_number,
            IFNULL(c.carry_balance,0) AS carry_balance,
            (b.amount - b.paid_amount) AS balance
        FROM customers c
        JOIN bills b ON b.customer_id = c.id
        WHERE c.`VC Number` = ?
        ORDER BY b.bill_year DESC, b.bill_month DESC
        LIMIT 1
    ";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $vc);

} else {

    if (!$adminId) {
        http_response_code(403);
        echo json_encode([
            "success" => false,
            "message" => "Admin mapping missing"
        ]);
        exit;
    }

    $sql = "
        SELECT 
            b.id AS bill_id,
            b.amount AS bill_amount,
            b.paid_amount,
            b.status,
            b.bill_month,
            b.bill_year,
            c.`Name` AS customer_name,
            c.`Account No` AS account_no,
            c.`VC Number` AS vc_number,
            IFNULL(c.carry_balance,0) AS carry_balance,
            (b.amount - b.paid_amount) AS balance
        FROM customers c
        JOIN bills b ON b.customer_id = c.id
        WHERE c.`VC Number` = ?
          AND c.admin_id = ?
        ORDER BY b.bill_year DESC, b.bill_month DESC
        LIMIT 1
    ";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("si", $vc, $adminId);
}

$stmt->execute();
$bill = $stmt->get_result()->fetch_assoc();
$stmt->close();

/*
|--------------------------------------------------------------------------
| RESPONSE
|--------------------------------------------------------------------------
*/
if ($bill) {
    echo json_encode([
        "success" => true,
        "bill" => $bill
    ], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
} else {
    echo json_encode([
        "success" => false,
        "message" => "No bill found"
    ]);
}
