<?php
header("Content-Type: application/json");

include_once "../admin/config/db.php";
include_once "jwt.php";

/* ================= JWT AUTH ================= */
$headers = getallheaders();
$auth = $headers['Authorization'] ?? '';

if (!$auth || !preg_match('/Bearer\s(\S+)/', $auth, $matches)) {
    http_response_code(401);
    echo json_encode(["success"=>false,"message"=>"Unauthorized"]);
    exit;
}

$user = verify_jwt($matches[1]);
if (!$user || empty($user['role'])) {
    http_response_code(401);
    echo json_encode(["success"=>false,"message"=>"Invalid token"]);
    exit;
}

$role    = $user['role'];
$adminId = $user['admin_id'] ?? null;

/* ================= INPUTS ================= */
$status     = strtoupper($_GET['status'] ?? 'ALL');
$billStatus = strtoupper($_GET['bill_status'] ?? '');
$area       = trim($_GET['area'] ?? '');

$where  = [];
$params = [];
$types  = "";

/* ================= CUSTOMER STATUS ================= */
if ($status !== 'ALL') {
    $where[] = "c.`Status` = ?";
    $params[] = $status;
    $types   .= "s";
}

/* ================= BILL STATUS (FIXED, SAFE) ================= */
if ($billStatus !== '') {

    if ($billStatus === 'NOT_GENERATED') {
        // Bill not created yet OR explicitly marked
        $where[] = "(b.status IS NULL OR b.status = 'NOT_GENERATED')";
    } else {
        // PAID / UNPAID / PARTIAL ONLY
        $where[] = "b.status = ?";
        $params[] = $billStatus;
        $types   .= "s";
    }
}

/* ================= AREA ================= */
if ($area !== '') {
    $where[] = "c.`Address` LIKE ?";
    $params[] = "%$area%";
    $types   .= "s";
}

/* ================= ADMIN ================= */
if ($role !== 'SUPER') {
    $where[] = "c.admin_id = ?";
    $params[] = $adminId;
    $types   .= "i";
}

/* ================= SQL ================= */
$sql = "
SELECT
    c.id,
    c.`Name` AS name,
    c.`Mobile No` AS mobile,
    c.`VC Number` AS vc_number,
    c.`Address` AS address,
    c.`Status` AS status,

    p.name  AS package_name,
    p.price AS package_amount,

    b.status AS bill_status,
    IFNULL(b.amount - b.paid_amount, 0) AS balance

FROM customers c
LEFT JOIN packages p ON p.id = c.`Package`
LEFT JOIN bills b
    ON b.customer_id = c.id
   AND (b.bill_year, b.bill_month) = (
        SELECT bill_year, bill_month
        FROM bills
        WHERE customer_id = c.id
        ORDER BY bill_year DESC, bill_month DESC
        LIMIT 1
   )
";

if ($where) {
    $sql .= " WHERE " . implode(" AND ", $where);
}

$sql .= " ORDER BY c.id DESC";

/* ================= EXECUTE ================= */
$stmt = $conn->prepare($sql);
if ($params) {
    $stmt->bind_param($types, ...$params);
}
$stmt->execute();

$res = $stmt->get_result();
$data = [];

while ($row = $res->fetch_assoc()) {
  $row['is_active'] = (strtoupper($row['status']) === 'ACTIVE');

    $row['is_paid']   = ($row['bill_status'] === 'PAID');
    $data[] = $row;
}
$stmt->close();

/* ================= RESPONSE ================= */
echo json_encode([
    "success" => true,
    "data" => $data
], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
