<?php

/*
|--------------------------------------------------------------------------
| JWT SECRET (KEEP SAFE)
|--------------------------------------------------------------------------
| Use a long random string (never phone number / simple text)
*/
$JWT_SECRET = "cabletv_9f8a7s6d5f4g3h2j1k_admin_secret";

/*
|--------------------------------------------------------------------------
| BASE64 URL SAFE HELPERS
|--------------------------------------------------------------------------
*/
function base64url_encode($data) {
    return rtrim(strtr(base64_encode($data), '+/', '-_'), '=');
}

function base64url_decode($data) {
    return base64_decode(strtr($data, '-_', '+/'));
}

/*
|--------------------------------------------------------------------------
| CREATE JWT (ACCESS or REFRESH)
|--------------------------------------------------------------------------
| $payload → custom data
| $exp     → seconds (default 1 day)
|--------------------------------------------------------------------------
*/
function create_jwt(array $payload, int $exp = 86400): string {
    global $JWT_SECRET;

    $header = [
        "alg" => "HS256",
        "typ" => "JWT"
    ];

    $now = time();

    // Standard claims
    $payload['iat'] = $now;
    $payload['exp'] = $now + $exp;

    $base64Header  = base64url_encode(json_encode($header));
    $base64Payload = base64url_encode(json_encode($payload));

    $signature = hash_hmac(
        "sha256",
        "$base64Header.$base64Payload",
        $JWT_SECRET,
        true
    );

    $base64Signature = base64url_encode($signature);

    return "$base64Header.$base64Payload.$base64Signature";
}

/*
|--------------------------------------------------------------------------
| VERIFY JWT
|--------------------------------------------------------------------------
| Returns payload array OR false
|--------------------------------------------------------------------------
*/
function verify_jwt(string $token) {
    global $JWT_SECRET;

    if (!$token) return false;

    $parts = explode('.', $token);
    if (count($parts) !== 3) return false;

    [$base64Header, $base64Payload, $base64Signature] = $parts;

    // Decode header
    $header = json_decode(base64url_decode($base64Header), true);
    if (!$header || ($header['alg'] ?? '') !== 'HS256') {
        return false;
    }

    // Verify signature
    $expectedSignature = base64url_encode(
        hash_hmac(
            'sha256',
            "$base64Header.$base64Payload",
            $JWT_SECRET,
            true
        )
    );

    if (!hash_equals($base64Signature, $expectedSignature)) {
        return false;
    }

    // Decode payload
    $payload = json_decode(base64url_decode($base64Payload), true);
    if (!$payload) return false;

    // Time validation (with 30s leeway)
    $now = time();
    if (!isset($payload['exp']) || ($payload['exp'] + 30) < $now) {
        return false;
    }

    return $payload;
}
