<?php
header("Content-Type: application/json");

include_once "../admin/config/db.php";
include_once __DIR__ . '/jwt.php';

$username = $_POST['username'] ?? '';
$password = $_POST['password'] ?? '';

$stmt = $conn->prepare(
    "SELECT id, password FROM officers WHERE username = ?"
);
$stmt->bind_param("s", $username);
$stmt->execute();
$res = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$res || !password_verify($password, $res['password'])) {
    echo json_encode([
        "success" => false,
        "message" => "Invalid login"
    ]);
    exit;
}

/* Create token */
$token = create_jwt([
    "officer_id" => $res['id'],
    "username"   => $username
]);

echo json_encode([
    "success" => true,
    "token" => $token
]);
