<?php
header("Content-Type: application/json");

include_once "../admin/config/db.php";
include_once __DIR__ . "/jwt.php";

/* ================= READ INPUT ================= */
$input = json_decode(file_get_contents("php://input"), true);

$username = trim($input['username'] ?? $_POST['username'] ?? '');
$password = trim($input['password'] ?? $_POST['password'] ?? '');

if ($username === '' || $password === '') {
    echo json_encode([
        "success" => false,
        "message" => "Username and password required"
    ]);
    exit;
}

/* ======================================================
   1️⃣ TRY ADMIN LOGIN FIRST
   ====================================================== */
$stmt = $conn->prepare("
    SELECT id, username, password, role
    FROM admins
    WHERE username = ?
    LIMIT 1
");
$stmt->bind_param("s", $username);
$stmt->execute();
$admin = $stmt->get_result()->fetch_assoc();
$stmt->close();

if ($admin && password_verify($password, $admin['password'])) {

    /* ===== CREATE ADMIN ACCESS TOKEN ===== */
    $accessToken = create_jwt([
        "role"       => $admin['role'], // SUPER / ADMIN
        "token_type" => "ADMIN",
        "admin_id"   => (int)$admin['id'],
        "username"   => $admin['username']
    ], 900);

    /* ===== REFRESH TOKEN ===== */
    $refreshToken = bin2hex(random_bytes(40));
    $expiresAt = date("Y-m-d H:i:s", time() + (7 * 24 * 60 * 60));

    $stmt = $conn->prepare("
        INSERT INTO refresh_tokens
        (token, user_type, user_id, expires_at)
        VALUES (?, 'ADMIN', ?, ?)
    ");
    $stmt->bind_param("sis", $refreshToken, $admin['id'], $expiresAt);
    $stmt->execute();
    $stmt->close();

    echo json_encode([
        "success"        => true,
        "access_token"  => $accessToken,
        "refresh_token" => $refreshToken,
        "name"          => $admin['username'],
        "role"          => $admin['role'],
        "user_type"     => "ADMIN"
    ]);
    exit;
}

/* ======================================================
   2️⃣ TRY OFFICER LOGIN
   ====================================================== */
$stmt = $conn->prepare("
    SELECT id, admin_id, password, status
    FROM officers
    WHERE username = ?
    LIMIT 1
");
$stmt->bind_param("s", $username);
$stmt->execute();
$officer = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (
    $officer &&
    $officer['status'] === 'Active' &&
    password_verify($password, $officer['password'])
) {

    /* ===== CREATE OFFICER ACCESS TOKEN ===== */
    $accessToken = create_jwt([
        "role"       => "OFFICER",
        "token_type" => "OFFICER",
        "officer_id" => (int)$officer['id'],
        "admin_id"   => (int)$officer['admin_id'],
        "username"   => $username
    ], 900);

    /* ===== REFRESH TOKEN ===== */
    $refreshToken = bin2hex(random_bytes(40));
    $expiresAt = date("Y-m-d H:i:s", time() + (7 * 24 * 60 * 60));

    $stmt = $conn->prepare("
        INSERT INTO refresh_tokens
        (token, user_type, user_id, expires_at)
        VALUES (?, 'OFFICER', ?, ?)
    ");
    $stmt->bind_param("sis", $refreshToken, $officer['id'], $expiresAt);
    $stmt->execute();
    $stmt->close();

    echo json_encode([
        "success"        => true,
        "access_token"  => $accessToken,
        "refresh_token" => $refreshToken,
        "name"          => $username,
        "role"          => "OFFICER",
        "user_type"     => "OFFICER"
    ]);
    exit;
}

/* ======================================================
   ❌ INVALID LOGIN
   ====================================================== */
echo json_encode([
    "success" => false,
    "message" => "Invalid login"
]);
exit;
