<?php
header("Content-Type: application/json");

include_once "../admin/config/db.php";
include_once "jwt.php";



/* ================= JWT AUTH ================= */

$headers = array_change_key_case(getallheaders(), CASE_LOWER);
$auth = $headers['authorization'] ?? '';

if (!$auth || !preg_match('/Bearer\s(\S+)/', $auth, $m)) {
    http_response_code(401);
    echo json_encode(["success"=>false,"message"=>"Unauthorized"]);
    exit;
}

$user = verify_jwt($m[1]);
if (!$user || empty($user['role'])) {
    http_response_code(401);
    echo json_encode(["success"=>false,"message"=>"Invalid token"]);
    exit;
}

$role    = strtoupper($user['role']);   // SUPER / ADMIN
$adminId = $user['admin_id'] ?? null;

/* ================= FIX: RESOLVE ADMIN_ID FOR OFFICER ================= */

if ($role === 'OFFICER' && empty($adminId)) {

    $officerId = $user['officer_id'] ?? 0;

    if ($officerId > 0) {
        $stmt = $conn->prepare("
            SELECT admin_id
            FROM officers
            WHERE id = ?
            LIMIT 1
        ");
        $stmt->bind_param("i", $officerId);
        $stmt->execute();
        $stmt->bind_result($adminId);
        $stmt->fetch();
        $stmt->close();
    }
}


/* ================= INPUT ================= */

$type = $_GET['type'] ?? '';
$from = $_GET['from'] ?? date('Y-m-01');
$to   = $_GET['to']   ?? date('Y-m-t');

/* ================= SWITCH ================= */

switch ($type) {

    /* ================= DAILY REPORT ================= */
    case "daily":

        if ($role === 'SUPER') {
            $res = $conn->query("
                SELECT 
                    DATE(payment_date) AS day,
                    SUM(amount) AS collected,
                    COUNT(DISTINCT bill_id) AS bills
                FROM payments
                WHERE DATE(payment_date) BETWEEN '$from' AND '$to'
                GROUP BY DATE(payment_date)
                ORDER BY day DESC
            ");
        } else {
            $stmt = $conn->prepare("
                SELECT 
                    DATE(p.payment_date) AS day,
                    SUM(p.amount) AS collected,
                    COUNT(DISTINCT p.bill_id) AS bills
                FROM payments p
                JOIN bills b ON p.bill_id=b.id
                JOIN customers c ON b.customer_id=c.id
                WHERE DATE(p.payment_date) BETWEEN ? AND ?
                  AND c.admin_id=?
                GROUP BY DATE(p.payment_date)
                ORDER BY day DESC
            ");
            $stmt->bind_param("ssi", $from, $to, $adminId);
            $stmt->execute();
            $res = $stmt->get_result();
        }

        $rows = [];
        while ($r = $res->fetch_assoc()) $rows[] = $r;

        echo json_encode(["success"=>true,"data"=>$rows]);
        break;

    /* ================= PAYMENT LOGS ================= */
    case "payment_logs":

        $mode = $_GET['mode'] ?? 'ALL';

        if ($role === 'SUPER') {

            $sql = "
                SELECT 
                    c.name AS customer,
                    p.amount,
                    p.mode,
                    DATE_FORMAT(p.payment_date,'%Y-%m-%d %H:%i') AS date
                FROM payments p
                JOIN bills b ON p.bill_id=b.id
                JOIN customers c ON b.customer_id=c.id
                WHERE DATE(p.payment_date) BETWEEN ? AND ?
            ";

            if ($mode !== 'ALL') {
                $sql .= " AND p.mode = ?";
            }

            $sql .= " ORDER BY p.payment_date DESC";

            $stmt = $conn->prepare($sql);

            if ($mode === 'ALL') {
                $stmt->bind_param("ss", $from, $to);
            } else {
                $stmt->bind_param("sss", $from, $to, $mode);
            }

        } else {

            $sql = "
                SELECT 
                    c.name AS customer,
                    p.amount,
                    p.mode,
                    DATE_FORMAT(p.payment_date,'%Y-%m-%d %H:%i') AS date
                FROM payments p
                JOIN bills b ON p.bill_id=b.id
                JOIN customers c ON b.customer_id=c.id
                WHERE DATE(p.payment_date) BETWEEN ? AND ?
                  AND c.admin_id=?
            ";

            if ($mode !== 'ALL') {
                $sql .= " AND p.mode = ?";
            }

            $sql .= " ORDER BY p.payment_date DESC";

            $stmt = $conn->prepare($sql);

            if ($mode === 'ALL') {
                $stmt->bind_param("ssi", $from, $to, $adminId);
            } else {
                $stmt->bind_param("ssis", $from, $to, $adminId, $mode);
            }
        }

        $stmt->execute();
        $res = $stmt->get_result();

        $rows = [];
        while ($r = $res->fetch_assoc()) $rows[] = $r;

        echo json_encode(["success"=>true,"data"=>$rows]);
        break;

  /* ================= PENDING CUSTOMER LIST ================= */
case "pending_list":

    if ($role === 'SUPER') {
        $res = $conn->query("
            SELECT 
                c.id,
                c.name,
                c.`VC Number` AS vc_number,
                SUM(b.amount - b.paid_amount) AS pending
            FROM bills b
            JOIN customers c ON b.customer_id = c.id
            WHERE b.status != 'PAID'
            GROUP BY c.id
            HAVING pending > 0
            ORDER BY pending DESC
        ");
    } else {
        $stmt = $conn->prepare("
            SELECT 
                c.id,
                c.name,
                c.`VC Number` AS vc_number,
                SUM(b.amount - b.paid_amount) AS pending
            FROM bills b
            JOIN customers c ON b.customer_id = c.id
            WHERE b.status != 'PAID'
              AND c.admin_id = ?
            GROUP BY c.id
            HAVING pending > 0
            ORDER BY pending DESC
        ");
        $stmt->bind_param("i", $adminId);
        $stmt->execute();
        $res = $stmt->get_result();
    }

    $rows = [];
    while ($r = $res->fetch_assoc()) {
        $rows[] = $r;
    }

    echo json_encode([
        "success" => true,
        "data" => $rows
    ]);
    break;

}
