<?php
include_once __DIR__ . '/../auth_check.php';
include_once __DIR__ . '/../config/db.php';

header("Content-Type: application/vnd.ms-excel");
header("Content-Disposition: attachment; filename=today_collection.xls");

$adminId = $_SESSION['admin_id'];
$role    = $_SESSION['admin_role'];
$today   = date('Y-m-d');

echo "Time\tCustomer\tAccount No\tVC No\tMobile\tBill ID\tAmount\n";

if ($role === 'SUPER') {

    $sql = "
        SELECT
            p.payment_date,
            p.amount,
            b.id AS bill_id,
            c.`Name`       AS customer_name,
            c.`Account No` AS account_no,
            c.`VC Number`  AS vc_number,
            c.`Mobile No`  AS mobile
        FROM payments p
        JOIN bills b ON p.bill_id = b.id
        JOIN customers c ON b.customer_id = c.id
        WHERE DATE(p.payment_date) = ?
        ORDER BY p.payment_date
    ";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $today);

} else {

    $sql = "
        SELECT
            p.payment_date,
            p.amount,
            b.id AS bill_id,
            c.`Name`       AS customer_name,
            c.`Account No` AS account_no,
            c.`VC Number`  AS vc_number,
            c.`Mobile No`  AS mobile
        FROM payments p
        JOIN bills b ON p.bill_id = b.id
        JOIN customers c ON b.customer_id = c.id
        WHERE c.admin_id = ?
          AND DATE(p.payment_date) = ?
        ORDER BY p.payment_date
    ";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("is", $adminId, $today);
}

$stmt->execute();
$res = $stmt->get_result();

while ($row = $res->fetch_assoc()) {

    echo
        date('H:i', strtotime($row['payment_date'])) . "\t" .
        $row['customer_name'] . "\t" .
        $row['account_no'] . "\t" .
        $row['vc_number'] . "\t" .
        $row['mobile'] . "\t" .
        $row['bill_id'] . "\t" .
        $row['amount'] . "\n";
}

exit;
