<?php
include_once __DIR__ . '/../auth_check.php';
include_once __DIR__ . '/../config/db.php';

header("Content-Type: text/plain");
header("Content-Disposition: attachment; filename=today_vc_list.txt");

$adminId = $_SESSION['admin_id'];
$role    = $_SESSION['admin_role'];
$today   = date('Y-m-d');

if ($role === 'SUPER') {

    $sql = "
        SELECT DISTINCT c.`VC Number` AS vc
        FROM payments p
        JOIN bills b ON p.bill_id = b.id
        JOIN customers c ON b.customer_id = c.id
        WHERE DATE(p.payment_date) = ?
    ";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $today);

} else {

    $sql = "
        SELECT DISTINCT c.`VC Number` AS vc
        FROM payments p
        JOIN bills b ON p.bill_id = b.id
        JOIN customers c ON b.customer_id = c.id
        WHERE c.admin_id = ?
          AND DATE(p.payment_date) = ?
    ";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("is", $adminId, $today);
}

$stmt->execute();
$res = $stmt->get_result();

$vcList = [];

while ($row = $res->fetch_assoc()) {
    if (!empty($row['vc'])) {
        $vcList[] = $row['vc'];
    }
}

echo implode(",", $vcList);
exit;
