<?php
include_once __DIR__ . '/../auth_check.php';
include_once __DIR__ . '/../config/db.php';

$adminId = $_SESSION['admin_id'];
$role    = $_SESSION['admin_role'];

$month = isset($_GET['month']) ? (int)$_GET['month'] : date('n');
$year  = isset($_GET['year'])  ? (int)$_GET['year']  : date('Y');

if ($role === 'SUPER') {

    $sql = "
        SELECT 
            COUNT(*) AS total_bills,
            IFNULL(SUM(amount),0) AS total_amount,
            IFNULL(SUM(paid_amount),0) AS total_paid,
            IFNULL(SUM(amount - paid_amount),0) AS total_pending
        FROM bills
        WHERE bill_month = ?
          AND bill_year  = ?
    ";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ii", $month, $year);

} else {

    $sql = "
        SELECT 
            COUNT(*) AS total_bills,
            IFNULL(SUM(b.amount),0) AS total_amount,
            IFNULL(SUM(b.paid_amount),0) AS total_paid,
            IFNULL(SUM(b.amount - b.paid_amount),0) AS total_pending
        FROM bills b
        JOIN customers c ON b.customer_id = c.id
        WHERE b.bill_month = ?
          AND b.bill_year  = ?
          AND c.admin_id  = ?
    ";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("iii", $month, $year, $adminId);
}

$stmt->execute();
$report = $stmt->get_result()->fetch_assoc();
$stmt->close();
?>
<!DOCTYPE html>
<html>
<head>
    <title>Monthly Billing Report</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>

<div class="container mt-4">

    <h3>Monthly Billing Report</h3>

    <!-- FILTER -->
    <form class="row g-2 mb-3">
        <div class="col-md-3">
            <select name="month" class="form-select">
                <?php for ($m=1;$m<=12;$m++): ?>
                    <option value="<?= $m ?>" <?= $m==$month?'selected':'' ?>>
                        <?= date('F', mktime(0,0,0,$m,1)) ?>
                    </option>
                <?php endfor; ?>
            </select>
        </div>

        <div class="col-md-3">
            <select name="year" class="form-select">
                <?php for ($y=date('Y')-2;$y<=date('Y');$y++): ?>
                    <option value="<?= $y ?>" <?= $y==$year?'selected':'' ?>>
                        <?= $y ?>
                    </option>
                <?php endfor; ?>
            </select>
        </div>

        <div class="col-md-3">
            <button class="btn btn-primary">View</button>
        </div>
    </form>

    <!-- SUMMARY -->
    <div class="row text-center">
        <div class="col-md-3">
            <div class="card p-3">
                <h6>Total Bills</h6>
                <h4><?= $report['total_bills'] ?></h4>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card p-3">
                <h6>Total Amount</h6>
                <h4>₹<?= number_format($report['total_amount'],2) ?></h4>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card p-3">
                <h6>Collected</h6>
                <h4 class="text-success">
                    ₹<?= number_format($report['total_paid'],2) ?>
                </h4>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card p-3">
                <h6>Pending</h6>
                <h4 class="text-danger">
                    ₹<?= number_format($report['total_pending'],2) ?>
                </h4>
            </div>
        </div>
    </div>

</div>

</body>
</html>
