<?php
include_once __DIR__ . '/../auth_check.php';
include_once __DIR__ . '/../config/db.php';

$adminId = $_SESSION['admin_id'];
$role    = $_SESSION['admin_role'];

/* ================= FILTERS ================= */
$fromDate  = $_GET['from'] ?? date('Y-m-d');
$toDate    = $_GET['to']   ?? date('Y-m-d');
$officerId = $_GET['officer_id'] ?? 'all';

/* ================= OFFICER LIST ================= */
if ($role === 'SUPER') {
    $officers = $conn->query("SELECT id, name FROM officers ORDER BY name");
} else {
    $stmt = $conn->prepare("
        SELECT id, name FROM officers
        WHERE admin_id = ?
        ORDER BY name
    ");
    $stmt->bind_param("i", $adminId);
    $stmt->execute();
    $officers = $stmt->get_result();
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Officer Wise Collection Report</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>

<div class="container-fluid mt-4">

    <h3 class="mb-3">Officer Wise Collection Report</h3>

    <!-- ================= FILTER FORM ================= -->
    <form method="get" class="row g-3 align-items-end mb-4">

        <div class="col-md-3">
            <label class="form-label">From Date</label>
            <input type="date" name="from"
                   value="<?= htmlspecialchars($fromDate) ?>"
                   class="form-control" required>
        </div>

        <div class="col-md-3">
            <label class="form-label">To Date</label>
            <input type="date" name="to"
                   value="<?= htmlspecialchars($toDate) ?>"
                   class="form-control" required>
        </div>

        <div class="col-md-3">
            <label class="form-label">Officer</label>
            <select name="officer_id" class="form-select">
                <option value="all">All Officers</option>
                <?php while ($o = $officers->fetch_assoc()): ?>
                    <option value="<?= $o['id'] ?>"
                        <?= $officerId == $o['id'] ? 'selected' : '' ?>>
                        <?= htmlspecialchars($o['name']) ?>
                    </option>
                <?php endwhile; ?>
            </select>
        </div>

        <div class="col-md-3">
            <button class="btn btn-primary w-100">
                View Report
            </button>
        </div>

    </form>

    <!-- ================= SUMMARY ================= -->
    <div class="card mb-4">
        <div class="card-header bg-dark text-white">
            Officer Summary
        </div>
        <div class="card-body table-responsive">

            <table class="table table-bordered table-striped">
                <thead class="table-dark">
                <tr>
                    <th>Officer</th>
                    <th>Total Payments</th>
                    <th>Total Amount (₹)</th>
                </tr>
                </thead>
                <tbody>

                <?php
                $conditions = "DATE(p.payment_date) BETWEEN ? AND ?";
                $params = [$fromDate, $toDate];
                $types  = "ss";

                if ($officerId !== 'all') {
                    $conditions .= " AND p.officer_id = ?";
                    $params[] = $officerId;
                    $types .= "i";
                }

                if ($role !== 'SUPER') {
                    $conditions .= " AND p.admin_id = ?";
                    $params[] = $adminId;
                    $types .= "i";
                }

                $sql = "
                    SELECT
                        o.name AS officer_name,
                        COUNT(p.id) AS total_payments,
                        SUM(p.amount) AS total_amount
                    FROM payments p
                    JOIN officers o ON p.officer_id = o.id
                    WHERE $conditions
                    GROUP BY o.id
                    ORDER BY total_amount DESC
                ";

                $stmt = $conn->prepare($sql);
                $stmt->bind_param($types, ...$params);
                $stmt->execute();
                $res = $stmt->get_result();

                if ($res->num_rows === 0) {
                    echo '<tr><td colspan="3" class="text-center">No data</td></tr>';
                }

                while ($row = $res->fetch_assoc()):
                ?>
                    <tr>
                        <td><?= htmlspecialchars($row['officer_name']) ?></td>
                        <td><?= (int)$row['total_payments'] ?></td>
                        <td class="fw-bold text-success">
                            ₹<?= number_format($row['total_amount'], 2) ?>
                        </td>
                    </tr>
                <?php endwhile; ?>
                </tbody>
            </table>

        </div>
    </div>

    <!-- ================= DETAILS ================= -->
    <div class="card">
        <div class="card-header bg-secondary text-white">
            Customer Payment Details
        </div>
        <div class="card-body table-responsive">

            <table class="table table-bordered table-striped">
                <thead class="table-dark">
                <tr>
                    <th>Date</th>
                    <th>Officer</th>
                    <th>Customer</th>
                    <th>VC No</th>
                    <th>Amount (₹)</th>
                    <th>Mode</th>
                </tr>
                </thead>
                <tbody>

                <?php
                $sql = "
                    SELECT
                        p.payment_date,
                        p.amount,
                        p.mode,
                        o.name AS officer_name,
                        c.`Name` AS customer_name,
                        c.`VC Number` AS vc_number
                    FROM payments p
                    JOIN officers o ON p.officer_id = o.id
                    JOIN bills b ON p.bill_id = b.id
                    JOIN customers c ON b.customer_id = c.id
                    WHERE $conditions
                    ORDER BY p.payment_date DESC
                ";

                $stmt = $conn->prepare($sql);
                $stmt->bind_param($types, ...$params);
                $stmt->execute();
                $res = $stmt->get_result();

                if ($res->num_rows === 0) {
                    echo '<tr><td colspan="6" class="text-center">No payments</td></tr>';
                }

                while ($row = $res->fetch_assoc()):
                ?>
                    <tr>
                        <td><?= date('d-m-Y H:i', strtotime($row['payment_date'])) ?></td>
                        <td><?= htmlspecialchars($row['officer_name']) ?></td>
                        <td><?= htmlspecialchars($row['customer_name']) ?></td>
                        <td><?= htmlspecialchars($row['vc_number']) ?></td>
                        <td class="fw-bold">₹<?= number_format($row['amount'],2) ?></td>
                        <td><?= htmlspecialchars($row['mode']) ?></td>
                    </tr>
                <?php endwhile; ?>
                </tbody>
            </table>

        </div>
    </div>

</div>

</body>
</html>
