<?php
include_once __DIR__ . '/../auth_check.php';
include_once __DIR__ . '/../config/db.php';

$adminId = $_SESSION['admin_id'];
$role    = $_SESSION['admin_role'];

/* ================= FILTER ================= */
$month = isset($_GET['month']) ? (int)$_GET['month'] : date('n');
$year  = isset($_GET['year'])  ? (int)$_GET['year']  : date('Y');

/* ================= QUERY ================= */
if ($role === 'SUPER') {

    $sql = "
        SELECT
            c.`Name`        AS customer_name,
            c.`VC Number`   AS vc,
            b.bill_month,
            b.bill_year,
            b.amount,
            b.paid_amount,
            (b.amount - b.paid_amount) AS balance,
            b.status
        FROM bills b
        JOIN customers c ON b.customer_id = c.id
        WHERE b.bill_month = ?
          AND b.bill_year  = ?
          AND b.status != 'PAID'
        ORDER BY balance DESC
    ";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ii", $month, $year);

} else {

    $sql = "
        SELECT
            c.`Name`        AS customer_name,
            c.`VC Number`   AS vc,
            b.bill_month,
            b.bill_year,
            b.amount,
            b.paid_amount,
            (b.amount - b.paid_amount) AS balance,
            b.status
        FROM bills b
        JOIN customers c ON b.customer_id = c.id
        WHERE b.bill_month = ?
          AND b.bill_year  = ?
          AND b.status != 'PAID'
          AND c.admin_id  = ?
        ORDER BY balance DESC
    ";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("iii", $month, $year, $adminId);
}

$stmt->execute();
$result = $stmt->get_result();
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Pending Bills Report</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>

<div class="container mt-4">

    <h3 class="mb-3">Pending Bills Report</h3>

    <!-- FILTER -->
    <form class="row g-2 mb-3">
        <div class="col-md-3">
            <select name="month" class="form-select">
                <?php for ($m=1;$m<=12;$m++): ?>
                    <option value="<?= $m ?>" <?= $m==$month?'selected':'' ?>>
                        <?= date('F', mktime(0,0,0,$m,1)) ?>
                    </option>
                <?php endfor; ?>
            </select>
        </div>

        <div class="col-md-3">
            <select name="year" class="form-select">
                <?php for ($y=date('Y')-2;$y<=date('Y');$y++): ?>
                    <option value="<?= $y ?>" <?= $y==$year?'selected':'' ?>>
                        <?= $y ?>
                    </option>
                <?php endfor; ?>
            </select>
        </div>

        <div class="col-md-3">
            <button class="btn btn-primary">View</button>
        </div>
    </form>

    <!-- TABLE -->
    <div class="table-responsive">
        <table class="table table-bordered table-striped align-middle">
            <thead class="table-dark">
            <tr>
                <th>#</th>
                <th>Customer</th>
                <th>VC No</th>
                <th>Bill</th>
                <th>Bill Amount</th>
                <th>Paid</th>
                <th>Pending</th>
                <th>Status</th>
            </tr>
            </thead>
            <tbody>

            <?php if ($result->num_rows > 0): ?>
                <?php $i=1; while ($row = $result->fetch_assoc()): ?>
                    <tr>
                        <td><?= $i++ ?></td>
                        <td><?= htmlspecialchars($row['customer_name']) ?></td>
                        <td><?= htmlspecialchars($row['vc']) ?></td>
                        <td><?= date('F', mktime(0,0,0,$row['bill_month'],1)) ?>
                            <?= $row['bill_year'] ?></td>

                        <td>₹<?= number_format($row['amount'],2) ?></td>
                        <td class="text-success">
                            ₹<?= number_format($row['paid_amount'],2) ?>
                        </td>

                        <td class="text-danger fw-bold">
                            ₹<?= number_format($row['balance'],2) ?>
                        </td>

                        <td>
                            <span class="badge <?= $row['status']=='PARTIAL'?'bg-warning':'bg-danger' ?>">
                                <?= $row['status'] ?>
                            </span>
                        </td>
                    </tr>
                <?php endwhile; ?>
            <?php else: ?>
                <tr>
                    <td colspan="8" class="text-center">No pending bills found</td>
                </tr>
            <?php endif; ?>

            </tbody>
        </table>
    </div>

    <a href="../dashboard.php" class="btn btn-secondary mt-3">Back</a>

</div>

</body>
</html>
